/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.gradoop.common.model.impl.properties.bytes.Bytes;

public class DateTimeSerializer {
    public static final int SIZEOF_DATE = 12;
    public static final int SIZEOF_TIME = 16;
    public static final int SIZEOF_DATETIME = 28;

    public static byte[] serializeDate(LocalDate date) {
        int year = date.getYear();
        int month = date.getMonth().getValue();
        int day = date.getDayOfMonth();
        return DateTimeSerializer.serialize(new int[]{year, month, day});
    }

    public static byte[] serializeTime(LocalTime time) {
        int hour = time.getHour();
        int minute = time.getMinute();
        int second = time.getSecond();
        int nano = time.getNano();
        return DateTimeSerializer.serialize(new int[]{hour, minute, second, nano});
    }

    public static byte[] serializeDateTime(LocalDateTime dateTime) {
        int year = dateTime.getYear();
        int month = dateTime.getMonth().getValue();
        int day = dateTime.getDayOfMonth();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int second = dateTime.getSecond();
        int nano = dateTime.getNano();
        return DateTimeSerializer.serialize(new int[]{year, month, day, hour, minute, second, nano});
    }

    private static byte[] serialize(int[] ints) {
        byte[] bytes = new byte[ints.length * 4];
        for (int i = 0; i < ints.length; ++i) {
            int offset = i * 4;
            Bytes.putInt(bytes, offset, ints[i]);
        }
        return bytes;
    }

    public static LocalDate deserializeDate(byte[] bytes) {
        int year = Bytes.toInt(bytes, 0, 4);
        int month = Bytes.toInt(bytes, 4, 4);
        int day = Bytes.toInt(bytes, 8, 4);
        return LocalDate.of(year, month, day);
    }

    public static LocalTime deserializeTime(byte[] bytes) {
        int hour = Bytes.toInt(bytes, 0, 4);
        int minute = Bytes.toInt(bytes, 4, 4);
        int second = Bytes.toInt(bytes, 8, 4);
        int nano = Bytes.toInt(bytes, 12, 4);
        return LocalTime.of(hour, minute, second, nano);
    }

    public static LocalDateTime deserializeDateTime(byte[] bytes) {
        int year = Bytes.toInt(bytes, 0, 4);
        int month = Bytes.toInt(bytes, 4, 4);
        int day = Bytes.toInt(bytes, 8, 4);
        int hour = Bytes.toInt(bytes, 12, 4);
        int minute = Bytes.toInt(bytes, 16, 4);
        int second = Bytes.toInt(bytes, 20, 4);
        int nano = Bytes.toInt(bytes, 24, 4);
        return LocalDateTime.of(year, month, day, hour, minute, second, nano);
    }
}

