/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.gradoop.common.model.impl.properties.Property;
import org.gradoop.common.model.impl.properties.PropertyValue;

public class Properties
implements Iterable<Property>,
Value,
Serializable {
    private static final int DEFAULT_CAPACITY = 10;
    private Map<String, PropertyValue> properties;

    public Properties() {
        this.properties = new HashMap<String, PropertyValue>(10);
    }

    private Properties(int capacity) {
        this.properties = new HashMap<String, PropertyValue>(capacity);
    }

    public static Properties create() {
        return new Properties();
    }

    public static Properties createWithCapacity(int capacity) {
        return new Properties(capacity);
    }

    public static Properties createFromMap(Map<String, Object> map) {
        Properties properties;
        if (map == null) {
            properties = Properties.createWithCapacity(0);
        } else {
            properties = Properties.createWithCapacity(map.size());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                properties.set(entry.getKey(), PropertyValue.create(entry.getValue()));
            }
        }
        return properties;
    }

    public Iterable<String> getKeys() {
        return this.properties.keySet();
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    public PropertyValue get(String key) {
        Objects.requireNonNull(key);
        return this.properties.get(key);
    }

    public void set(Property property) {
        this.set(property.getKey(), property.getValue());
    }

    public void set(String key, PropertyValue value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.properties.put(key, value);
    }

    public void set(String key, Object value) {
        PropertyValue propertyValue = value instanceof PropertyValue ? (PropertyValue)value : PropertyValue.create(value);
        this.set(key, propertyValue);
    }

    public PropertyValue remove(String key) {
        Objects.requireNonNull(key);
        return this.properties.remove(key);
    }

    public PropertyValue remove(Property property) {
        Objects.requireNonNull(property);
        return this.remove(property.getKey());
    }

    public void clear() {
        this.properties.clear();
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Properties that = (Properties)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return this.properties != null ? this.properties.hashCode() : 0;
    }

    @Override
    public Iterator<Property> iterator() {
        return this.toList().iterator();
    }

    public List<Property> toList() {
        return this.properties.entrySet().stream().map(e -> Property.create((String)e.getKey(), (PropertyValue)e.getValue())).collect(Collectors.toList());
    }

    public void write(DataOutputView outputView) throws IOException {
        outputView.writeInt(this.properties.size());
        for (Map.Entry<String, PropertyValue> entry : this.properties.entrySet()) {
            outputView.writeUTF(entry.getKey());
            entry.getValue().write(outputView);
        }
    }

    public void read(DataInputView inputView) throws IOException {
        int propertyCount = inputView.readInt();
        this.properties = new HashMap<String, PropertyValue>(propertyCount);
        for (int i = 0; i < propertyCount; ++i) {
            String key = inputView.readUTF();
            PropertyValue value = new PropertyValue();
            value.read(inputView);
            this.properties.put(key, value);
        }
    }

    public String toString() {
        return this.toList().stream().map(Property::toString).collect(Collectors.joining(","));
    }
}

