/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.gradoop.common.model.impl.properties.PropertyValue;

public class Property
implements Value,
Serializable,
Comparable<Property> {
    private String key;
    private PropertyValue value;

    public Property() {
    }

    Property(String key, PropertyValue value) {
        Preconditions.checkNotNull((Object)key, (Object)"Property key was null");
        Preconditions.checkNotNull((Object)value, (Object)"Property value was null");
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"Property key was empty");
        this.key = key;
        this.value = value;
    }

    public static Property create(String key, PropertyValue value) {
        return new Property(key, value);
    }

    public static Property create(String key, Object value) {
        return new Property(key, PropertyValue.create(value));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Property key was null");
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"Property key was empty");
        this.key = key;
    }

    public PropertyValue getValue() {
        return this.value;
    }

    public void setValue(PropertyValue value) {
        this.value = (PropertyValue)Preconditions.checkNotNull((Object)value, (Object)"Property value was null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        return this.key.equals(property.key) && this.value.equals(property.value);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    @Override
    public int compareTo(Property o) {
        return this.getKey().compareTo(o.getKey());
    }

    public void write(DataOutputView outputView) throws IOException {
        outputView.writeUTF(this.key);
        this.value.write(outputView);
    }

    public void read(DataInputView inputView) throws IOException {
        this.key = inputView.readUTF();
        this.value = new PropertyValue();
        this.value.read(inputView);
    }

    public String toString() {
        return String.format("%s=%s:%s", this.key, this.value, this.value.getType() != null ? this.value.getType().getSimpleName() : "null");
    }
}

