/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.gradoop.common.exceptions.UnsupportedTypeException;
import org.gradoop.common.model.api.strategies.PropertyValueStrategy;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.strategies.PropertyValueStrategyFactory;

public class PropertyValue
implements Value,
Serializable,
Comparable<PropertyValue> {
    public static final PropertyValue NULL_VALUE = PropertyValue.create(null);
    public static final transient byte OFFSET = 1;
    public static final transient byte FLAG_LARGE = -128;
    public static final transient int LARGE_PROPERTY_THRESHOLD = Short.MAX_VALUE;
    private static final long serialVersionUID = 1L;
    private Object value;

    public PropertyValue() {
    }

    private PropertyValue(Object value) {
        this.setObject(value);
    }

    private PropertyValue(byte[] bytes) {
        this.setBytes(bytes);
    }

    public static PropertyValue create(Object value) {
        return new PropertyValue(value);
    }

    public static PropertyValue fromRawBytes(byte[] rawBytes) {
        return new PropertyValue(rawBytes);
    }

    public PropertyValue copy() {
        return new PropertyValue(this.getRawBytes());
    }

    public boolean is(Class clazz) {
        return PropertyValueStrategyFactory.get(clazz).is(this.value);
    }

    public boolean isNull() {
        return this.getRawBytes()[0] == Type.NULL.getTypeByte();
    }

    public boolean isBoolean() {
        return this.is(Boolean.class);
    }

    public boolean isShort() {
        return this.is(Short.class);
    }

    public boolean isInt() {
        return this.is(Integer.class);
    }

    public boolean isLong() {
        return this.is(Long.class);
    }

    public boolean isFloat() {
        return this.is(Float.class);
    }

    public boolean isDouble() {
        return this.is(Double.class);
    }

    public boolean isString() {
        return this.is(String.class);
    }

    public boolean isBigDecimal() {
        return this.is(BigDecimal.class);
    }

    public boolean isGradoopId() {
        return this.is(GradoopId.class);
    }

    public boolean isMap() {
        return this.is(Map.class);
    }

    public boolean isList() {
        return this.is(List.class);
    }

    public boolean isDate() {
        return this.is(LocalDate.class);
    }

    public boolean isTime() {
        return this.is(LocalTime.class);
    }

    public boolean isDateTime() {
        return this.is(LocalDateTime.class);
    }

    public boolean isSet() {
        return this.is(Set.class);
    }

    public boolean isNumber() {
        return !this.isNull() && Number.class.isAssignableFrom(this.getType());
    }

    public <T> T get(Class<T> clazz) throws UnsupportedOperationException {
        PropertyValueStrategy strategy = PropertyValueStrategyFactory.get(clazz);
        if (strategy.is(this.value)) {
            return (T)this.value;
        }
        String type = this.value == null ? "null" : this.value.getClass().getSimpleName();
        throw new UnsupportedOperationException("Value '" + this.value + "' of type " + type + ", cannot be accessed as " + clazz.getSimpleName());
    }

    public Object getObject() {
        Object obj = null;
        if (this.value != null) {
            obj = this.get(this.value.getClass());
        }
        return obj;
    }

    public boolean getBoolean() {
        return this.get(Boolean.class);
    }

    public short getShort() {
        return this.get(Short.class);
    }

    public int getInt() {
        return this.get(Integer.class);
    }

    public long getLong() {
        return this.get(Long.class);
    }

    public float getFloat() {
        return this.get(Float.class).floatValue();
    }

    public double getDouble() {
        return this.get(Double.class);
    }

    public String getString() {
        return this.get(String.class);
    }

    public BigDecimal getBigDecimal() {
        return this.get(BigDecimal.class);
    }

    public GradoopId getGradoopId() {
        return this.get(GradoopId.class);
    }

    public Map<PropertyValue, PropertyValue> getMap() {
        return this.get(Map.class);
    }

    public List<PropertyValue> getList() {
        return this.get(List.class);
    }

    public LocalDate getDate() {
        return this.get(LocalDate.class);
    }

    public LocalTime getTime() {
        return this.get(LocalTime.class);
    }

    public LocalDateTime getDateTime() {
        return this.get(LocalDateTime.class);
    }

    public Set<PropertyValue> getSet() {
        return this.get(Set.class);
    }

    public void setObject(Object value) {
        if (value != null && !PropertyValueStrategyFactory.get(value.getClass()).is(value)) {
            throw new UnsupportedTypeException(value.getClass());
        }
        this.value = value;
    }

    public void setBoolean(boolean booleanValue) {
        this.setObject(booleanValue);
    }

    public void setShort(short shortValue) {
        this.setObject(shortValue);
    }

    public void setInt(int intValue) {
        this.setObject(intValue);
    }

    public void setLong(long longValue) {
        this.setObject(longValue);
    }

    public void setFloat(float floatValue) {
        this.setObject(Float.valueOf(floatValue));
    }

    public void setDouble(double doubleValue) {
        this.setObject(doubleValue);
    }

    public void setString(String stringValue) {
        this.setObject(stringValue);
    }

    public void setBigDecimal(BigDecimal bigDecimalValue) {
        this.setObject(bigDecimalValue);
    }

    public void setGradoopId(GradoopId gradoopIdValue) {
        this.setObject(gradoopIdValue);
    }

    public void setMap(Map<PropertyValue, PropertyValue> map) {
        this.setObject(map);
    }

    public void setList(List<PropertyValue> list) {
        this.setObject(list);
    }

    public void setDate(LocalDate date) {
        this.setObject(date);
    }

    public void setTime(LocalTime time) {
        this.setObject(time);
    }

    public void setDateTime(LocalDateTime dateTime) {
        this.setObject(dateTime);
    }

    public void setSet(Set<PropertyValue> set) {
        this.setObject(set);
    }

    public Class<?> getType() {
        Class clazz = null;
        if (this.value != null) {
            clazz = PropertyValueStrategyFactory.get(this.value.getClass()).getType();
        }
        return clazz;
    }

    public int getByteSize() {
        return this.getRawBytes().length;
    }

    public byte[] getRawBytes() {
        return PropertyValueStrategyFactory.getRawBytes(this.value);
    }

    public void setBytes(byte[] bytes) {
        this.value = PropertyValueStrategyFactory.fromRawBytes(bytes);
    }

    public boolean equals(Object object) {
        return object instanceof PropertyValue && Objects.equals(this.value, ((PropertyValue)object).value);
    }

    public int hashCode() {
        return Arrays.hashCode(PropertyValueStrategyFactory.getRawBytes(this.value));
    }

    @Override
    public int compareTo(PropertyValue other) {
        return PropertyValueStrategyFactory.compare(this.value, other.value);
    }

    public int byteSize() {
        byte[] rawBytes = PropertyValueStrategyFactory.getRawBytes(this.value);
        return rawBytes.length;
    }

    public void write(DataOutputView outputView) throws IOException {
        PropertyValueStrategyFactory.get(this.value).write(this.value, outputView);
    }

    public void read(DataInputView inputView) throws IOException {
        byte typeByte = inputView.readByte();
        byte type = (byte)(0x7F & typeByte);
        PropertyValueStrategy strategy = PropertyValueStrategyFactory.get(type);
        if (strategy == null) {
            throw new UnsupportedTypeException("No strategy for type byte from input view found");
        }
        this.value = strategy.read(inputView, typeByte);
    }

    public String toString() {
        return this.getObject() != null ? this.getObject().toString() : "NULL";
    }
}

