/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.types.Value;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.common.model.impl.properties.bytes.Bytes;

public class PropertyValueList
implements Iterable<PropertyValue>,
Serializable,
Value,
Comparable<PropertyValueList> {
    private static final long serialVersionUID = 1L;
    private byte[] bytes;

    public PropertyValueList() {
    }

    private PropertyValueList(byte[] bytes) {
        this.bytes = bytes;
    }

    public static PropertyValueList createEmptyList() {
        return new PropertyValueList(new byte[0]);
    }

    public static PropertyValueList fromPropertyValues(Collection<PropertyValue> propertyValues) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteStream);
        DataOutputViewStreamWrapper outputView = new DataOutputViewStreamWrapper((OutputStream)outputStream);
        for (PropertyValue propertyValue : propertyValues) {
            propertyValue.write((DataOutputView)outputView);
        }
        outputStream.flush();
        return new PropertyValueList(byteStream.toByteArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyValueList)) {
            return false;
        }
        PropertyValueList that = (PropertyValueList)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public Iterator<PropertyValue> iterator() {
        return new PropertyValueListIterator(this.bytes);
    }

    public void write(DataOutputView dataOutput) throws IOException {
        dataOutput.writeShort(this.bytes.length);
        dataOutput.write(this.bytes);
    }

    public void read(DataInputView dataInput) throws IOException {
        this.bytes = new byte[dataInput.readShort()];
        dataInput.readFully(this.bytes);
    }

    @Override
    public int compareTo(PropertyValueList o) {
        return Bytes.compareTo(this.bytes, o.bytes);
    }

    public String toString() {
        return StringUtils.join(this.iterator(), (char)',');
    }

    private static class PropertyValueListIterator
    implements Iterator<PropertyValue> {
        private final ByteArrayInputStream byteStream;
        private final DataInputStream inputStream;

        PropertyValueListIterator(byte[] rawBytes) {
            if (rawBytes == null) {
                rawBytes = new byte[]{};
            }
            this.byteStream = new ByteArrayInputStream(rawBytes);
            this.inputStream = new DataInputStream(this.byteStream);
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            if (this.byteStream.available() > 0) {
                hasNext = true;
            } else {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                hasNext = false;
            }
            return hasNext;
        }

        @Override
        public PropertyValue next() throws NoSuchElementException {
            PropertyValue nextValue = new PropertyValue();
            try {
                DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)this.inputStream);
                nextValue.read((DataInputView)inputView);
            }
            catch (IOException e) {
                throw new NoSuchElementException("Error while reading from input stream.");
            }
            return nextValue;
        }

        @Override
        public void remove() {
        }
    }
}

