/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Arrays;
import org.gradoop.common.exceptions.UnsupportedTypeException;
import org.gradoop.common.model.impl.properties.PropertyValue;

public class PropertyValueUtils {

    public static class BytesUtils {
        public static byte[] getRawBytesWithoutType(PropertyValue value) {
            return Arrays.copyOfRange(value.getRawBytes(), 1, value.getRawBytes().length);
        }

        public static byte[] getTypeByte(PropertyValue value) {
            byte[] typeByte = new byte[]{value.getRawBytes()[0]};
            return typeByte;
        }

        public static PropertyValue createFromTypeValueBytes(byte[] typeByte, byte[] valueBytes) {
            byte[] validValue = new byte[valueBytes.length + 1];
            validValue[0] = typeByte[0];
            System.arraycopy(valueBytes, 0, validValue, 1, valueBytes.length);
            return PropertyValue.fromRawBytes(validValue);
        }
    }

    public static class Numeric {
        private static final int SHORT = 0;
        private static final int INT = 1;
        private static final int LONG = 2;
        private static final int FLOAT = 3;
        private static final int DOUBLE = 4;
        private static final int BIG_DECIMAL = 5;

        public static PropertyValue add(PropertyValue aValue, PropertyValue bValue) {
            int bType;
            int aType = Numeric.checkNumericalAndGetType(aValue);
            boolean sameType = aType == (bType = Numeric.checkNumericalAndGetType(bValue));
            int returnType = Numeric.maxType(aType, bType);
            if (returnType == 1) {
                int a = aType == 1 ? aValue.getInt() : (int)aValue.getShort();
                int b = bType == 1 ? bValue.getInt() : (int)bValue.getShort();
                aValue.setInt(a + b);
            } else if (returnType == 3) {
                float b;
                float a;
                if (sameType) {
                    a = aValue.getFloat();
                    b = bValue.getFloat();
                } else {
                    a = aType == 3 ? aValue.getFloat() : Numeric.floatValue(aValue, aType);
                    b = bType == 3 ? bValue.getFloat() : Numeric.floatValue(bValue, bType);
                }
                aValue.setFloat(a + b);
            } else if (returnType == 2) {
                long b;
                long a;
                if (sameType) {
                    a = aValue.getLong();
                    b = bValue.getLong();
                } else {
                    a = aType == 2 ? aValue.getLong() : Numeric.longValue(aValue, aType);
                    b = bType == 2 ? bValue.getLong() : Numeric.longValue(bValue, bType);
                }
                aValue.setLong(a + b);
            } else if (returnType == 4) {
                double b;
                double a;
                if (sameType) {
                    a = aValue.getDouble();
                    b = bValue.getDouble();
                } else {
                    a = aType == 4 ? aValue.getDouble() : Numeric.doubleValue(aValue, aType);
                    b = bType == 4 ? bValue.getDouble() : Numeric.doubleValue(bValue, bType);
                }
                aValue.setDouble(a + b);
            } else {
                BigDecimal b;
                BigDecimal a;
                if (sameType) {
                    a = aValue.getBigDecimal();
                    b = bValue.getBigDecimal();
                } else {
                    a = aType == 5 ? aValue.getBigDecimal() : Numeric.bigDecimalValue(aValue, aType);
                    b = bType == 5 ? bValue.getBigDecimal() : Numeric.bigDecimalValue(bValue, bType);
                }
                aValue.setBigDecimal(a.add(b));
            }
            return aValue;
        }

        private static int maxType(int aType, int bType) {
            return Math.max(Math.max(aType, bType), 1);
        }

        public static PropertyValue multiply(PropertyValue aValue, PropertyValue bValue) {
            int bType;
            int aType = Numeric.checkNumericalAndGetType(aValue);
            boolean sameType = aType == (bType = Numeric.checkNumericalAndGetType(bValue));
            int returnType = Numeric.maxType(aType, bType);
            if (returnType == 1) {
                int a = aType == 1 ? aValue.getInt() : (int)aValue.getShort();
                int b = bType == 1 ? bValue.getInt() : (int)bValue.getShort();
                aValue.setInt(a * b);
            } else if (returnType == 3) {
                float b;
                float a;
                if (sameType) {
                    a = aValue.getFloat();
                    b = bValue.getFloat();
                } else {
                    a = aType == 3 ? aValue.getFloat() : Numeric.floatValue(aValue, aType);
                    b = bType == 3 ? bValue.getFloat() : Numeric.floatValue(bValue, bType);
                }
                aValue.setFloat(a * b);
            } else if (returnType == 2) {
                long b;
                long a;
                if (sameType) {
                    a = aValue.getLong();
                    b = bValue.getLong();
                } else {
                    a = aType == 2 ? aValue.getLong() : Numeric.longValue(aValue, aType);
                    b = bType == 2 ? bValue.getLong() : Numeric.longValue(bValue, bType);
                }
                aValue.setLong(a * b);
            } else if (returnType == 4) {
                double b;
                double a;
                if (sameType) {
                    a = aValue.getDouble();
                    b = bValue.getDouble();
                } else {
                    a = aType == 4 ? aValue.getDouble() : Numeric.doubleValue(aValue, aType);
                    b = bType == 4 ? bValue.getDouble() : Numeric.doubleValue(bValue, bType);
                }
                aValue.setDouble(a * b);
            } else {
                BigDecimal b;
                BigDecimal a;
                if (sameType) {
                    a = aValue.getBigDecimal();
                    b = bValue.getBigDecimal();
                } else {
                    a = aType == 5 ? aValue.getBigDecimal() : Numeric.bigDecimalValue(aValue, aType);
                    b = bType == 5 ? bValue.getBigDecimal() : Numeric.bigDecimalValue(bValue, bType);
                }
                aValue.setBigDecimal(a.multiply(b));
            }
            return aValue;
        }

        public static int compare(PropertyValue aValue, PropertyValue bValue) {
            int result;
            int bType;
            int aType = Numeric.checkNumericalAndGetType(aValue);
            boolean sameType = aType == (bType = Numeric.checkNumericalAndGetType(bValue));
            int maxType = Math.max(aType, bType);
            if (maxType == 0) {
                result = Short.compare(aValue.getShort(), bValue.getShort());
            } else if (maxType == 1) {
                int b;
                int a;
                if (sameType) {
                    a = aValue.getInt();
                    b = bValue.getInt();
                } else {
                    a = aType == 1 ? aValue.getInt() : (int)aValue.getShort();
                    b = bType == 1 ? bValue.getInt() : (int)bValue.getShort();
                }
                result = Integer.compare(a, b);
            } else if (maxType == 3) {
                float b;
                float a;
                if (sameType) {
                    a = aValue.getFloat();
                    b = bValue.getFloat();
                } else {
                    a = aType == 3 ? aValue.getFloat() : Numeric.floatValue(aValue, aType);
                    b = bType == 3 ? bValue.getFloat() : Numeric.floatValue(bValue, bType);
                }
                result = Float.compare(a, b);
            } else if (maxType == 2) {
                long b;
                long a;
                if (sameType) {
                    a = aValue.getLong();
                    b = bValue.getLong();
                } else {
                    a = aType == 2 ? aValue.getLong() : Numeric.longValue(aValue, aType);
                    b = bType == 2 ? bValue.getLong() : Numeric.longValue(bValue, bType);
                }
                result = Long.compare(a, b);
            } else if (maxType == 4) {
                double b;
                double a;
                if (sameType) {
                    a = aValue.getDouble();
                    b = bValue.getDouble();
                } else {
                    a = aType == 4 ? aValue.getDouble() : Numeric.doubleValue(aValue, aType);
                    b = bType == 4 ? bValue.getDouble() : Numeric.doubleValue(bValue, bType);
                }
                result = Double.compare(a, b);
            } else {
                BigDecimal b;
                BigDecimal a;
                if (sameType) {
                    a = aValue.getBigDecimal();
                    b = bValue.getBigDecimal();
                } else {
                    a = aType == 5 ? aValue.getBigDecimal() : Numeric.bigDecimalValue(aValue, aType);
                    b = bType == 5 ? bValue.getBigDecimal() : Numeric.bigDecimalValue(bValue, bType);
                }
                result = a.compareTo(b);
            }
            return result;
        }

        public static PropertyValue min(PropertyValue a, PropertyValue b) {
            return Numeric.isLessOrEqualThan(a, b) ? a : b;
        }

        public static PropertyValue max(PropertyValue a, PropertyValue b) {
            return Numeric.isLessOrEqualThan(a, b) ? b : a;
        }

        private static boolean isLessOrEqualThan(PropertyValue aValue, PropertyValue bValue) {
            boolean aIsLessOrEqual;
            int bType;
            int aType = Numeric.checkNumericalAndGetType(aValue);
            boolean sameType = aType == (bType = Numeric.checkNumericalAndGetType(bValue));
            int returnType = Numeric.maxType(aType, bType);
            if (returnType == 1) {
                int a = aType == 1 ? aValue.getInt() : (int)aValue.getShort();
                int b = bType == 1 ? bValue.getInt() : (int)bValue.getShort();
                aIsLessOrEqual = a <= b;
            } else if (returnType == 3) {
                float b;
                float a;
                if (sameType) {
                    a = aValue.getFloat();
                    b = bValue.getFloat();
                } else {
                    a = aType == 3 ? aValue.getFloat() : Numeric.floatValue(aValue, aType);
                    b = bType == 3 ? bValue.getFloat() : Numeric.floatValue(bValue, bType);
                }
                aIsLessOrEqual = a <= b;
            } else if (returnType == 2) {
                long b;
                long a;
                if (sameType) {
                    a = aValue.getLong();
                    b = bValue.getLong();
                } else {
                    a = aType == 2 ? aValue.getLong() : Numeric.longValue(aValue, aType);
                    b = bType == 2 ? bValue.getLong() : Numeric.longValue(bValue, bType);
                }
                aIsLessOrEqual = a <= b;
            } else if (returnType == 4) {
                double b;
                double a;
                if (sameType) {
                    a = aValue.getDouble();
                    b = bValue.getDouble();
                } else {
                    a = aType == 4 ? aValue.getDouble() : Numeric.doubleValue(aValue, aType);
                    b = bType == 4 ? bValue.getDouble() : Numeric.doubleValue(bValue, bType);
                }
                aIsLessOrEqual = a <= b;
            } else {
                BigDecimal b;
                BigDecimal a;
                if (sameType) {
                    a = aValue.getBigDecimal();
                    b = bValue.getBigDecimal();
                } else {
                    a = aType == 5 ? aValue.getBigDecimal() : Numeric.bigDecimalValue(aValue, aType);
                    b = bType == 5 ? bValue.getBigDecimal() : Numeric.bigDecimalValue(bValue, bType);
                }
                aIsLessOrEqual = a.compareTo(b) <= 0;
            }
            return aIsLessOrEqual;
        }

        private static int checkNumericalAndGetType(PropertyValue value) {
            int type;
            Preconditions.checkNotNull((Object)value);
            if (value.isShort()) {
                type = 0;
            } else if (value.isInt()) {
                type = 1;
            } else if (value.isLong()) {
                type = 2;
            } else if (value.isFloat()) {
                type = 3;
            } else if (value.isDouble()) {
                type = 4;
            } else if (value.isBigDecimal()) {
                type = 5;
            } else {
                throw new UnsupportedTypeException(value.getObject().getClass());
            }
            return type;
        }

        private static BigDecimal bigDecimalValue(PropertyValue value, int type) {
            switch (type) {
                case 0: {
                    return BigDecimal.valueOf(value.getShort());
                }
                case 1: {
                    return BigDecimal.valueOf(value.getInt());
                }
                case 2: {
                    return BigDecimal.valueOf(value.getLong());
                }
                case 3: {
                    return BigDecimal.valueOf(value.getFloat());
                }
            }
            return BigDecimal.valueOf(value.getDouble());
        }

        private static double doubleValue(PropertyValue value, int type) {
            switch (type) {
                case 0: {
                    return value.getShort();
                }
                case 1: {
                    return value.getInt();
                }
                case 2: {
                    return value.getLong();
                }
            }
            return value.getFloat();
        }

        private static long longValue(PropertyValue value, int type) {
            switch (type) {
                case 0: {
                    return value.getShort();
                }
            }
            return value.getInt();
        }

        private static float floatValue(PropertyValue value, int type) {
            switch (type) {
                case 0: {
                    return value.getShort();
                }
                case 1: {
                    return value.getInt();
                }
            }
            return value.getLong();
        }
    }

    public static class Boolean {
        public static PropertyValue or(PropertyValue a, PropertyValue b) {
            Preconditions.checkNotNull((Object)a, (Object)b);
            Boolean.checkBoolean(a);
            Boolean.checkBoolean(b);
            a.setBoolean(a.getBoolean() || b.getBoolean());
            return a;
        }

        private static void checkBoolean(PropertyValue value) {
            if (!value.isBoolean()) {
                throw new UnsupportedTypeException(value.getObject().getClass());
            }
        }
    }
}

