/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.bytes;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Comparator;
import org.gradoop.common.model.impl.properties.bytes.UnsafeAvailChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class Bytes
implements Comparable<Bytes> {
    public static final int SIZEOF_BOOLEAN = 1;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_SHORT = 2;
    private static final boolean UNSAFE_UNALIGNED = UnsafeAvailChecker.unaligned();
    private static final Logger LOG = LoggerFactory.getLogger(Bytes.class);
    private byte[] bytes;
    private int offset;
    private int length;
    private final ByteArrayComparator bytesRawcomparator = new ByteArrayComparator();

    public Bytes() {
    }

    public Bytes(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public Bytes(Bytes ibw) {
        this(ibw.get(), ibw.getOffset(), ibw.getLength());
    }

    public Bytes(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public byte[] get() {
        if (this.bytes == null) {
            throw new IllegalStateException("Uninitialiized. Null constructor called w/o accompaying readFields invocation");
        }
        return this.bytes;
    }

    public void set(byte[] b) {
        this.set(b, 0, b.length);
    }

    public void set(byte[] b, int offset, int length) {
        this.bytes = b;
        this.offset = offset;
        this.length = length;
    }

    public int getLength() {
        if (this.bytes == null) {
            throw new IllegalStateException("Uninitialiized. Null constructor called w/o accompaying readFields invocation");
        }
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        return Bytes.hashCode(this.bytes, this.offset, this.length);
    }

    @Override
    public int compareTo(Bytes that) {
        return this.bytesRawcomparator.compare(this.bytes, this.offset, this.length, that.bytes, that.offset, that.length);
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that instanceof Bytes) {
            return this.compareTo((Bytes)that) == 0;
        }
        return false;
    }

    public String toString() {
        return Bytes.toString(this.bytes, this.offset, this.length);
    }

    public static int putBytes(byte[] tgtBytes, int tgtOffset, byte[] srcBytes, int srcOffset, int srcLength) {
        System.arraycopy(srcBytes, srcOffset, tgtBytes, tgtOffset, srcLength);
        return tgtOffset + srcLength;
    }

    public static int putByte(byte[] bytes, int offset, byte b) {
        bytes[offset] = b;
        return offset + 1;
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return null;
        }
        return Bytes.toString(b, 0, b.length);
    }

    public static String toString(byte[] b1, String sep, byte[] b2) {
        return Bytes.toString(b1, 0, b1.length) + sep + Bytes.toString(b2, 0, b2.length);
    }

    public static String toString(byte[] b, int off) {
        if (b == null) {
            return null;
        }
        int len = b.length - off;
        if (len <= 0) {
            return "";
        }
        return new String(b, off, len, StandardCharsets.UTF_8);
    }

    public static String toString(byte[] b, int off, int len) {
        if (b == null) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        return new String(b, off, len, StandardCharsets.UTF_8);
    }

    public static byte[] toBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static long toLong(byte[] bytes) {
        return Bytes.toLong(bytes, 0, 8);
    }

    public static long toLong(byte[] bytes, int offset) {
        return Bytes.toLong(bytes, offset, 8);
    }

    public static long toLong(byte[] bytes, int offset, int length) {
        if (length != 8 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 8);
        }
        if (UNSAFE_UNALIGNED) {
            return Bytes.toLongUnsafe(bytes, offset);
        }
        long l = 0L;
        for (int i = offset; i < offset + length; ++i) {
            l <<= 8;
            l ^= (long)(bytes[i] & 0xFF);
        }
        return l;
    }

    private static IllegalArgumentException explainWrongLengthOrOffset(byte[] bytes, int offset, int length, int expectedLength) {
        String reason = length != expectedLength ? "Wrong length: " + length + ", expected " + expectedLength : "offset (" + offset + ") + length (" + length + ") exceed the capacity of the array: " + bytes.length;
        return new IllegalArgumentException(reason);
    }

    public static int putLong(byte[] bytes, int offset, long val) {
        if (bytes.length - offset < 8) {
            throw new IllegalArgumentException("Not enough room to put a long at offset " + offset + " in a " + bytes.length + " byte array");
        }
        if (UNSAFE_UNALIGNED) {
            return Bytes.putLongUnsafe(bytes, offset, val);
        }
        for (int i = offset + 7; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 8;
    }

    private static int putLongUnsafe(byte[] bytes, int offset, long val) {
        if (LexicographicalComparerHolder.UnsafeComparer.LITTLE_ENDIAN) {
            val = Long.reverseBytes(val);
        }
        LexicographicalComparerHolder.UnsafeComparer.UNSAFE.putLong(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET, val);
        return offset + 8;
    }

    public static float toFloat(byte[] bytes) {
        return Bytes.toFloat(bytes, 0);
    }

    public static float toFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(Bytes.toInt(bytes, offset, 4));
    }

    public static int putFloat(byte[] bytes, int offset, float f) {
        return Bytes.putInt(bytes, offset, Float.floatToRawIntBits(f));
    }

    public static double toDouble(byte[] bytes) {
        return Bytes.toDouble(bytes, 0);
    }

    public static double toDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(Bytes.toLong(bytes, offset, 8));
    }

    public static int putDouble(byte[] bytes, int offset, double d) {
        return Bytes.putLong(bytes, offset, Double.doubleToLongBits(d));
    }

    public static int toInt(byte[] bytes) {
        return Bytes.toInt(bytes, 0, 4);
    }

    public static int toInt(byte[] bytes, int offset) {
        return Bytes.toInt(bytes, offset, 4);
    }

    public static int toInt(byte[] bytes, int offset, int length) {
        if (length != 4 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 4);
        }
        if (UNSAFE_UNALIGNED) {
            return Bytes.toIntUnsafe(bytes, offset);
        }
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static int toIntUnsafe(byte[] bytes, int offset) {
        if (LexicographicalComparerHolder.UnsafeComparer.LITTLE_ENDIAN) {
            return Integer.reverseBytes(LexicographicalComparerHolder.UnsafeComparer.UNSAFE.getInt(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET));
        }
        return LexicographicalComparerHolder.UnsafeComparer.UNSAFE.getInt(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET);
    }

    private static short toShortUnsafe(byte[] bytes, int offset) {
        if (LexicographicalComparerHolder.UnsafeComparer.LITTLE_ENDIAN) {
            return Short.reverseBytes(LexicographicalComparerHolder.UnsafeComparer.UNSAFE.getShort(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET));
        }
        return LexicographicalComparerHolder.UnsafeComparer.UNSAFE.getShort(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET);
    }

    private static long toLongUnsafe(byte[] bytes, int offset) {
        if (LexicographicalComparerHolder.UnsafeComparer.LITTLE_ENDIAN) {
            return Long.reverseBytes(LexicographicalComparerHolder.UnsafeComparer.UNSAFE.getLong(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET));
        }
        return LexicographicalComparerHolder.UnsafeComparer.UNSAFE.getLong(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET);
    }

    public static int putInt(byte[] bytes, int offset, int val) {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("Not enough room to put an int at offset " + offset + " in a " + bytes.length + " byte array");
        }
        if (UNSAFE_UNALIGNED) {
            return Bytes.putIntUnsafe(bytes, offset, val);
        }
        for (int i = offset + 3; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 4;
    }

    private static int putIntUnsafe(byte[] bytes, int offset, int val) {
        if (LexicographicalComparerHolder.UnsafeComparer.LITTLE_ENDIAN) {
            val = Integer.reverseBytes(val);
        }
        LexicographicalComparerHolder.UnsafeComparer.UNSAFE.putInt(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET, val);
        return offset + 4;
    }

    public static short toShort(byte[] bytes) {
        return Bytes.toShort(bytes, 0, 2);
    }

    public static short toShort(byte[] bytes, int offset) {
        return Bytes.toShort(bytes, offset, 2);
    }

    public static short toShort(byte[] bytes, int offset, int length) {
        if (length != 2 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 2);
        }
        if (UNSAFE_UNALIGNED) {
            return Bytes.toShortUnsafe(bytes, offset);
        }
        short n = 0;
        n = (short)((n ^ bytes[offset]) & 0xFF);
        n = (short)(n << 8);
        n = (short)((n ^ bytes[offset + 1]) & 0xFF);
        return n;
    }

    public static int putShort(byte[] bytes, int offset, short val) {
        if (bytes.length - offset < 2) {
            throw new IllegalArgumentException("Not enough room to put a short at offset " + offset + " in a " + bytes.length + " byte array");
        }
        if (UNSAFE_UNALIGNED) {
            return Bytes.putShortUnsafe(bytes, offset, val);
        }
        bytes[offset + 1] = (byte)val;
        val = (short)(val >> 8);
        bytes[offset] = (byte)val;
        return offset + 2;
    }

    private static int putShortUnsafe(byte[] bytes, int offset, short val) {
        if (LexicographicalComparerHolder.UnsafeComparer.LITTLE_ENDIAN) {
            val = Short.reverseBytes(val);
        }
        LexicographicalComparerHolder.UnsafeComparer.UNSAFE.putShort(bytes, (long)offset + (long)LexicographicalComparerHolder.UnsafeComparer.BYTE_ARRAY_BASE_OFFSET, val);
        return offset + 2;
    }

    public static byte[] toBytes(BigDecimal val) {
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        int offset = Bytes.putInt(result, 0, val.scale());
        Bytes.putBytes(result, offset, valueBytes, 0, valueBytes.length);
        return result;
    }

    public static BigDecimal toBigDecimal(byte[] bytes) {
        return Bytes.toBigDecimal(bytes, 0, bytes.length);
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        if (bytes == null || length < 5 || offset + length > bytes.length) {
            return null;
        }
        int scale = Bytes.toInt(bytes, offset);
        byte[] tcBytes = new byte[length - 4];
        System.arraycopy(bytes, offset + 4, tcBytes, 0, length - 4);
        return new BigDecimal(new BigInteger(tcBytes), scale);
    }

    public static int compareTo(byte[] left, byte[] right) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(left, 0, left.length, right, 0, right.length);
    }

    public static int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(buffer1, offset1, length1, buffer2, offset2, length2);
    }

    private static Comparer<byte[]> lexicographicalComparerJavaImpl() {
        return LexicographicalComparerHolder.PureJavaComparer.INSTANCE;
    }

    public static int hashCode(byte[] bytes, int offset, int length) {
        int hash = 1;
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    static class LexicographicalComparerHolder {
        static final String UNSAFE_COMPARER_NAME = LexicographicalComparerHolder.class.getName() + "$UnsafeComparer";
        static final Comparer<byte[]> BEST_COMPARER = LexicographicalComparerHolder.getBestComparer();

        LexicographicalComparerHolder() {
        }

        static Comparer<byte[]> getBestComparer() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARER_NAME);
                Comparer comparer = (Comparer)theClass.getEnumConstants()[0];
                return comparer;
            }
            catch (ClassNotFoundException t) {
                return Bytes.lexicographicalComparerJavaImpl();
            }
        }

        static enum UnsafeComparer implements Comparer<byte[]>
        {
            INSTANCE;

            static final Unsafe UNSAFE;
            static final int BYTE_ARRAY_BASE_OFFSET;
            static final boolean LITTLE_ENDIAN;

            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                int i;
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int stride = 8;
                int minLength = Math.min(length1, length2);
                int strideLimit = minLength & 0xFFFFFFF8;
                long offset1Adj = (long)offset1 + (long)BYTE_ARRAY_BASE_OFFSET;
                long offset2Adj = (long)offset2 + (long)BYTE_ARRAY_BASE_OFFSET;
                for (i = 0; i < strideLimit; i += 8) {
                    long rw;
                    long lw = UNSAFE.getLong(buffer1, offset1Adj + (long)i);
                    if (lw == (rw = UNSAFE.getLong(buffer2, offset2Adj + (long)i))) continue;
                    if (!LITTLE_ENDIAN) {
                        return lw + Long.MIN_VALUE < rw + Long.MIN_VALUE ? -1 : 1;
                    }
                    int n = Long.numberOfTrailingZeros(lw ^ rw) & 0xFFFFFFF8;
                    return (int)(lw >>> n & 0xFFL) - (int)(rw >>> n & 0xFFL);
                }
                while (i < minLength) {
                    int a = buffer1[offset1 + i] & 0xFF;
                    int b = buffer2[offset2 + i] & 0xFF;
                    if (a != b) {
                        return a - b;
                    }
                    ++i;
                }
                return length1 - length2;
            }

            static {
                if (!UNSAFE_UNALIGNED) {
                    throw new Error();
                }
                UNSAFE = (Unsafe)AccessController.doPrivileged(() -> {
                    try {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return f.get(null);
                    }
                    catch (ReflectiveOperationException e) {
                        LOG.warn("sun.misc.Unsafe is not accessible");
                        return null;
                    }
                });
                BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
                if (UNSAFE.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
                LITTLE_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
            }
        }

        static enum PureJavaComparer implements Comparer<byte[]>
        {
            INSTANCE;


            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int end1 = offset1 + length1;
                int end2 = offset2 + length2;
                int i = offset1;
                for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
                    int a = buffer1[i] & 0xFF;
                    int b = buffer2[j] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return length1 - length2;
            }
        }
    }

    static interface Comparer<T> {
        public int compareTo(T var1, int var2, int var3, T var4, int var5, int var6);
    }

    public static class ByteArrayComparator
    implements Comparator<byte[]> {
        ByteArrayComparator() {
        }

        @Override
        public int compare(byte[] left, byte[] right) {
            return Bytes.compareTo(left, right);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return LexicographicalComparerHolder.BEST_COMPARER.compareTo(b1, s1, l1, b2, s2, l2);
        }
    }
}

