/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.bytes;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnsafeAvailChecker {
    private static final String CLASS_NAME = "sun.misc.Unsafe";
    private static boolean UNALIGNED = false;
    private static final Logger LOG = LoggerFactory.getLogger(UnsafeAvailChecker.class);

    private UnsafeAvailChecker() {
    }

    static boolean unaligned() {
        return UNALIGNED;
    }

    static {
        boolean avail = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Class<?> clazz = Class.forName(UnsafeAvailChecker.CLASS_NAME);
                    Field f = clazz.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    return f.get(null) != null;
                }
                catch (ReflectiveOperationException e) {
                    LOG.warn("sun.misc.Unsafe is not available/accessible");
                    return false;
                }
            }
        });
        if (avail) {
            String arch = System.getProperty("os.arch");
            if ("ppc64".equals(arch) || "ppc64le".equals(arch)) {
                UNALIGNED = true;
            } else {
                try {
                    Class<?> clazz = Class.forName("java.nio.Bits");
                    Method m = clazz.getDeclaredMethod("unaligned", new Class[0]);
                    m.setAccessible(true);
                    UNALIGNED = (Boolean)m.invoke(null, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    LOG.warn("java.nio.Bits#unaligned() check failed. Unsafe based read/write of primitive typeswon't be used", (Throwable)e);
                }
            }
        }
    }
}

