/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.gradoop.common.model.api.strategies.PropertyValueStrategy;

public abstract class AbstractVariableSizedPropertyValueStrategy<T>
implements PropertyValueStrategy<T> {
    @Override
    public void write(T value, DataOutputView outputView) throws IOException {
        byte[] rawBytes = this.getRawBytes(value);
        byte type = rawBytes[0];
        if (rawBytes.length > Short.MAX_VALUE) {
            type = (byte)(type | 0xFFFFFF80);
        }
        outputView.writeByte((int)type);
        if ((type & 0xFFFFFF80) == -128) {
            outputView.writeInt(rawBytes.length - 1);
        } else {
            outputView.writeShort(rawBytes.length - 1);
        }
        outputView.write(rawBytes, 1, rawBytes.length - 1);
    }

    byte[] readVariableSizedData(DataInputView inputView, byte typeByte) throws IOException {
        int length = (typeByte & 0xFFFFFF80) == -128 ? inputView.readInt() : (int)inputView.readShort();
        byte[] rawBytes = new byte[length];
        for (int i = 0; i < rawBytes.length; ++i) {
            rawBytes[i] = inputView.readByte();
        }
        return rawBytes;
    }

    DataInputViewStreamWrapper createInputView(byte[] bytes) {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        DataInputStream inputStream = new DataInputStream(byteStream);
        return new DataInputViewStreamWrapper((InputStream)inputStream);
    }
}

