/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.flink.core.memory.DataInputView;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.bytes.Bytes;
import org.gradoop.common.model.impl.properties.strategies.AbstractVariableSizedPropertyValueStrategy;
import org.gradoop.common.model.impl.properties.strategies.PropertyValueStrategyUtils;

public class BigDecimalStrategy
extends AbstractVariableSizedPropertyValueStrategy<BigDecimal> {
    @Override
    public BigDecimal read(DataInputView inputView, byte typeByte) throws IOException {
        byte[] rawBytes = this.readVariableSizedData(inputView, typeByte);
        return Bytes.toBigDecimal(rawBytes);
    }

    @Override
    public int compare(BigDecimal value, Object other) {
        if (other instanceof Number) {
            Number num = (Number)other;
            return PropertyValueStrategyUtils.compareNumerical(value, num);
        }
        throw new IllegalArgumentException(String.format("Incompatible types: %s, %s", value.getClass(), other.getClass()));
    }

    @Override
    public boolean is(Object value) {
        return value instanceof BigDecimal;
    }

    @Override
    public Class<BigDecimal> getType() {
        return BigDecimal.class;
    }

    @Override
    public BigDecimal get(byte[] bytes) {
        return Bytes.toBigDecimal(bytes, 1, bytes.length - 1);
    }

    @Override
    public byte getRawType() {
        return Type.BIG_DECIMAL.getTypeByte();
    }

    @Override
    public byte[] getRawBytes(BigDecimal value) {
        byte[] valueBytes = Bytes.toBytes(value);
        byte[] rawBytes = new byte[1 + valueBytes.length];
        rawBytes[0] = this.getRawType();
        Bytes.putBytes(rawBytes, 1, valueBytes, 0, valueBytes.length);
        return rawBytes;
    }
}

