/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.bytes.Bytes;
import org.gradoop.common.model.impl.properties.strategies.AbstractFixSizedPropertyValueStrategy;

public class BooleanStrategy
extends AbstractFixSizedPropertyValueStrategy<Boolean> {
    @Override
    public Boolean read(DataInputView inputView, byte typeByte) throws IOException {
        return inputView.readByte() == -1;
    }

    @Override
    public int compare(Boolean value, Object other) {
        if (other.getClass() == Boolean.class) {
            return Boolean.compare(value, (Boolean)other);
        }
        throw new IllegalArgumentException(String.format("Incompatible types: %s, %s", value.getClass(), other.getClass()));
    }

    @Override
    public boolean is(Object value) {
        return value instanceof Boolean;
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public Boolean get(byte[] bytes) {
        return bytes[1] == -1;
    }

    @Override
    public byte getRawType() {
        return Type.BOOLEAN.getTypeByte();
    }

    @Override
    public byte[] getRawBytes(Boolean value) {
        byte[] rawBytes = new byte[2];
        rawBytes[0] = this.getRawType();
        Bytes.putByte(rawBytes, 1, (byte)(value != false ? -1 : 0));
        return rawBytes;
    }
}

