/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import org.apache.flink.core.memory.DataInputView;
import org.gradoop.common.model.impl.properties.DateTimeSerializer;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.bytes.Bytes;
import org.gradoop.common.model.impl.properties.strategies.AbstractFixSizedPropertyValueStrategy;

public class DateStrategy
extends AbstractFixSizedPropertyValueStrategy<LocalDate> {
    @Override
    public LocalDate read(DataInputView inputView, byte typeByte) throws IOException {
        int length = 12;
        byte[] rawBytes = new byte[length];
        for (int i = 0; i < rawBytes.length; ++i) {
            rawBytes[i] = inputView.readByte();
        }
        return DateTimeSerializer.deserializeDate(rawBytes);
    }

    @Override
    public int compare(LocalDate value, Object other) {
        if (other instanceof LocalDate) {
            return value.compareTo((LocalDate)other);
        }
        throw new IllegalArgumentException(String.format("Incompatible types: %s, %s", value.getClass(), other.getClass()));
    }

    @Override
    public boolean is(Object value) {
        return value instanceof LocalDate;
    }

    @Override
    public Class<LocalDate> getType() {
        return LocalDate.class;
    }

    @Override
    public LocalDate get(byte[] bytes) {
        return DateTimeSerializer.deserializeDate(Arrays.copyOfRange(bytes, 1, 13));
    }

    @Override
    public byte getRawType() {
        return Type.DATE.getTypeByte();
    }

    @Override
    public byte[] getRawBytes(LocalDate value) {
        byte[] valueBytes = DateTimeSerializer.serializeDate(value);
        byte[] rawBytes = new byte[13];
        rawBytes[0] = this.getRawType();
        Bytes.putBytes(rawBytes, 1, valueBytes, 0, valueBytes.length);
        return rawBytes;
    }
}

