/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.apache.flink.core.memory.DataInputView;
import org.gradoop.common.model.impl.properties.DateTimeSerializer;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.bytes.Bytes;
import org.gradoop.common.model.impl.properties.strategies.AbstractFixSizedPropertyValueStrategy;

public class DateTimeStrategy
extends AbstractFixSizedPropertyValueStrategy<LocalDateTime> {
    @Override
    public LocalDateTime read(DataInputView inputView, byte typeByte) throws IOException {
        int length = 28;
        byte[] rawBytes = new byte[length];
        for (int i = 0; i < rawBytes.length; ++i) {
            rawBytes[i] = inputView.readByte();
        }
        return DateTimeSerializer.deserializeDateTime(rawBytes);
    }

    @Override
    public int compare(LocalDateTime value, Object other) {
        if (other instanceof LocalDateTime) {
            return value.compareTo((LocalDateTime)other);
        }
        throw new IllegalArgumentException(String.format("Incompatible types: %s, %s", value.getClass(), other.getClass()));
    }

    @Override
    public boolean is(Object value) {
        return value instanceof LocalDateTime;
    }

    @Override
    public Class<LocalDateTime> getType() {
        return LocalDateTime.class;
    }

    @Override
    public LocalDateTime get(byte[] bytes) {
        return DateTimeSerializer.deserializeDateTime(Arrays.copyOfRange(bytes, 1, 29));
    }

    @Override
    public byte getRawType() {
        return Type.DATE_TIME.getTypeByte();
    }

    @Override
    public byte[] getRawBytes(LocalDateTime value) {
        byte[] valueBytes = DateTimeSerializer.serializeDateTime(value);
        byte[] rawBytes = new byte[29];
        rawBytes[0] = this.getRawType();
        Bytes.putBytes(rawBytes, 1, valueBytes, 0, valueBytes.length);
        return rawBytes;
    }
}

