/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.bytes.Bytes;
import org.gradoop.common.model.impl.properties.strategies.AbstractFixSizedPropertyValueStrategy;
import org.gradoop.common.model.impl.properties.strategies.PropertyValueStrategyUtils;

public class DoubleStrategy
extends AbstractFixSizedPropertyValueStrategy<Double> {
    @Override
    public Double read(DataInputView inputView, byte typeByte) throws IOException {
        int length = 8;
        byte[] rawBytes = new byte[length];
        for (int i = 0; i < rawBytes.length; ++i) {
            rawBytes[i] = inputView.readByte();
        }
        return Bytes.toDouble(rawBytes);
    }

    @Override
    public int compare(Double value, Object other) {
        return PropertyValueStrategyUtils.compareNumerical(value, other);
    }

    @Override
    public boolean is(Object value) {
        return value instanceof Double;
    }

    @Override
    public Class<Double> getType() {
        return Double.class;
    }

    @Override
    public Double get(byte[] bytes) {
        return Bytes.toDouble(bytes, 1);
    }

    @Override
    public byte getRawType() {
        return Type.DOUBLE.getTypeByte();
    }

    @Override
    public byte[] getRawBytes(Double value) {
        byte[] rawBytes = new byte[9];
        rawBytes[0] = this.getRawType();
        Bytes.putDouble(rawBytes, 1, value);
        return rawBytes;
    }
}

