/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.bytes.Bytes;
import org.gradoop.common.model.impl.properties.strategies.AbstractFixSizedPropertyValueStrategy;
import org.gradoop.common.model.impl.properties.strategies.PropertyValueStrategyUtils;

public class FloatStrategy
extends AbstractFixSizedPropertyValueStrategy<Float> {
    @Override
    public Float read(DataInputView inputView, byte typeByte) throws IOException {
        int length = 4;
        byte[] rawBytes = new byte[length];
        for (int i = 0; i < rawBytes.length; ++i) {
            rawBytes[i] = inputView.readByte();
        }
        return Float.valueOf(Bytes.toFloat(rawBytes));
    }

    @Override
    public int compare(Float value, Object other) {
        return PropertyValueStrategyUtils.compareNumerical(value, other);
    }

    @Override
    public boolean is(Object value) {
        return value instanceof Float;
    }

    @Override
    public Class<Float> getType() {
        return Float.class;
    }

    @Override
    public Float get(byte[] bytes) {
        return Float.valueOf(Bytes.toFloat(bytes, 1));
    }

    @Override
    public byte getRawType() {
        return Type.FLOAT.getTypeByte();
    }

    @Override
    public byte[] getRawBytes(Float value) {
        byte[] rawBytes = new byte[5];
        rawBytes[0] = this.getRawType();
        Bytes.putFloat(rawBytes, 1, value.floatValue());
        return rawBytes;
    }
}

