/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.core.memory.DataInputView;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.bytes.Bytes;
import org.gradoop.common.model.impl.properties.strategies.AbstractFixSizedPropertyValueStrategy;

public class GradoopIdStrategy
extends AbstractFixSizedPropertyValueStrategy<GradoopId> {
    @Override
    public GradoopId read(DataInputView inputView, byte typeByte) throws IOException {
        int length = 12;
        byte[] rawBytes = new byte[length];
        for (int i = 0; i < rawBytes.length; ++i) {
            rawBytes[i] = inputView.readByte();
        }
        return GradoopId.fromByteArray(rawBytes);
    }

    @Override
    public int compare(GradoopId value, Object other) {
        if (other instanceof GradoopId) {
            return value.compareTo((GradoopId)other);
        }
        throw new IllegalArgumentException(String.format("Incompatible types: %s, %s", value.getClass(), other.getClass()));
    }

    @Override
    public boolean is(Object value) {
        return value instanceof GradoopId;
    }

    @Override
    public Class<GradoopId> getType() {
        return GradoopId.class;
    }

    @Override
    public GradoopId get(byte[] bytes) {
        return GradoopId.fromByteArray(Arrays.copyOfRange(bytes, 1, 13));
    }

    @Override
    public byte getRawType() {
        return Type.GRADOOP_ID.getTypeByte();
    }

    @Override
    public byte[] getRawBytes(GradoopId value) {
        byte[] valueBytes = value.toByteArray();
        byte[] rawBytes = new byte[13];
        rawBytes[0] = this.getRawType();
        Bytes.putBytes(rawBytes, 1, valueBytes, 0, valueBytes.length);
        return rawBytes;
    }
}

