/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.bytes.Bytes;
import org.gradoop.common.model.impl.properties.strategies.AbstractFixSizedPropertyValueStrategy;
import org.gradoop.common.model.impl.properties.strategies.PropertyValueStrategyUtils;

public class IntegerStrategy
extends AbstractFixSizedPropertyValueStrategy<Integer> {
    @Override
    public Integer read(DataInputView inputView, byte typeByte) throws IOException {
        int length = 4;
        byte[] rawBytes = new byte[length];
        for (int i = 0; i < rawBytes.length; ++i) {
            rawBytes[i] = inputView.readByte();
        }
        return Bytes.toInt(rawBytes);
    }

    @Override
    public int compare(Integer value, Object other) {
        return PropertyValueStrategyUtils.compareNumerical(value, other);
    }

    @Override
    public boolean is(Object value) {
        return value instanceof Integer;
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public Integer get(byte[] bytes) {
        return Bytes.toInt(bytes, 1);
    }

    @Override
    public byte getRawType() {
        return Type.INTEGER.getTypeByte();
    }

    @Override
    public byte[] getRawBytes(Integer value) {
        byte[] rawBytes = new byte[5];
        rawBytes[0] = this.getRawType();
        Bytes.putInt(rawBytes, 1, value);
        return rawBytes;
    }
}

