/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.bytes.Bytes;
import org.gradoop.common.model.impl.properties.strategies.AbstractFixSizedPropertyValueStrategy;
import org.gradoop.common.model.impl.properties.strategies.PropertyValueStrategyUtils;

public class LongStrategy
extends AbstractFixSizedPropertyValueStrategy<Long> {
    @Override
    public Long read(DataInputView inputView, byte typeByte) throws IOException {
        int length = 8;
        byte[] rawBytes = new byte[length];
        for (int i = 0; i < rawBytes.length; ++i) {
            rawBytes[i] = inputView.readByte();
        }
        return Bytes.toLong(rawBytes);
    }

    @Override
    public int compare(Long value, Object other) {
        return PropertyValueStrategyUtils.compareNumerical(value, other);
    }

    @Override
    public boolean is(Object value) {
        return value instanceof Long;
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }

    @Override
    public Long get(byte[] bytes) {
        return Bytes.toLong(bytes, 1);
    }

    @Override
    public byte getRawType() {
        return Type.LONG.getTypeByte();
    }

    @Override
    public byte[] getRawBytes(Long value) {
        byte[] rawBytes = new byte[9];
        rawBytes[0] = this.getRawType();
        Bytes.putLong(rawBytes, 1, value);
        return rawBytes;
    }
}

