/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradoop.common.exceptions.UnsupportedTypeException;
import org.gradoop.common.model.api.strategies.PropertyValueStrategy;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.strategies.BigDecimalStrategy;
import org.gradoop.common.model.impl.properties.strategies.BooleanStrategy;
import org.gradoop.common.model.impl.properties.strategies.DateStrategy;
import org.gradoop.common.model.impl.properties.strategies.DateTimeStrategy;
import org.gradoop.common.model.impl.properties.strategies.DoubleStrategy;
import org.gradoop.common.model.impl.properties.strategies.FloatStrategy;
import org.gradoop.common.model.impl.properties.strategies.GradoopIdStrategy;
import org.gradoop.common.model.impl.properties.strategies.IntegerStrategy;
import org.gradoop.common.model.impl.properties.strategies.ListStrategy;
import org.gradoop.common.model.impl.properties.strategies.LongStrategy;
import org.gradoop.common.model.impl.properties.strategies.MapStrategy;
import org.gradoop.common.model.impl.properties.strategies.NullStrategy;
import org.gradoop.common.model.impl.properties.strategies.SetStrategy;
import org.gradoop.common.model.impl.properties.strategies.ShortStrategy;
import org.gradoop.common.model.impl.properties.strategies.StringStrategy;
import org.gradoop.common.model.impl.properties.strategies.TimeStrategy;

public class PropertyValueStrategyFactory {
    private static PropertyValueStrategyFactory INSTANCE = new PropertyValueStrategyFactory();
    private final Map<Class, PropertyValueStrategy> classStrategyMap;
    private final PropertyValueStrategy[] byteStrategyMap;
    private final NullStrategy nullStrategy = new NullStrategy();

    private PropertyValueStrategyFactory() {
        this.classStrategyMap = this.initClassStrategyMap();
        this.byteStrategyMap = this.initByteStrategyMap();
    }

    public static Object fromRawBytes(byte[] bytes) {
        PropertyValueStrategy strategy = PropertyValueStrategyFactory.INSTANCE.byteStrategyMap[bytes[0]];
        try {
            return strategy == null ? null : strategy.get(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while deserializing object.", e);
        }
    }

    public static int compare(Object value, Object other) {
        if (value == null || other == null) {
            return PropertyValueStrategyFactory.INSTANCE.nullStrategy.compare(value, other);
        }
        PropertyValueStrategy strategy = PropertyValueStrategyFactory.get(value.getClass());
        return strategy.compare(value, other);
    }

    public static byte[] getRawBytes(Object value) {
        if (value != null) {
            try {
                return PropertyValueStrategyFactory.get(value.getClass()).getRawBytes(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while serializing object.", e);
            }
        }
        return new byte[]{Type.NULL.getTypeByte()};
    }

    public static PropertyValueStrategy get(byte value) throws UnsupportedTypeException {
        PropertyValueStrategy strategy = PropertyValueStrategyFactory.INSTANCE.byteStrategyMap[value];
        if (strategy == null) {
            throw new UnsupportedTypeException("No strategy for type byte " + value);
        }
        return strategy;
    }

    public static PropertyValueStrategy get(Class clazz) throws UnsupportedTypeException {
        if (clazz == null) {
            return PropertyValueStrategyFactory.INSTANCE.nullStrategy;
        }
        PropertyValueStrategy strategy = PropertyValueStrategyFactory.INSTANCE.classStrategyMap.get(clazz);
        if (strategy == null) {
            if (Map.class.isAssignableFrom(clazz)) {
                strategy = PropertyValueStrategyFactory.INSTANCE.classStrategyMap.get(Map.class);
            } else if (Set.class.isAssignableFrom(clazz)) {
                strategy = PropertyValueStrategyFactory.INSTANCE.classStrategyMap.get(Set.class);
            } else if (List.class.isAssignableFrom(clazz)) {
                strategy = PropertyValueStrategyFactory.INSTANCE.classStrategyMap.get(List.class);
            }
        }
        if (strategy == null) {
            throw new UnsupportedTypeException("No strategy for class " + clazz);
        }
        return strategy;
    }

    public static PropertyValueStrategy get(Object value) throws UnsupportedTypeException {
        if (value != null) {
            PropertyValueStrategy strategy = PropertyValueStrategyFactory.get(value.getClass());
            if (strategy == null) {
                throw new UnsupportedTypeException("No strategy for class " + value.getClass());
            }
            return PropertyValueStrategyFactory.get(value.getClass());
        }
        return PropertyValueStrategyFactory.INSTANCE.nullStrategy;
    }

    private Map<Class, PropertyValueStrategy> initClassStrategyMap() {
        HashMap<Class<Map>, PropertyValueStrategy<Boolean>> classMapping = new HashMap<Class<Map>, PropertyValueStrategy<Boolean>>();
        classMapping.put(Boolean.class, new BooleanStrategy());
        classMapping.put(Set.class, new SetStrategy());
        classMapping.put(Integer.class, new IntegerStrategy());
        classMapping.put(Long.class, new LongStrategy());
        classMapping.put(Float.class, new FloatStrategy());
        classMapping.put(Double.class, new DoubleStrategy());
        classMapping.put(Short.class, new ShortStrategy());
        classMapping.put(BigDecimal.class, new BigDecimalStrategy());
        classMapping.put(LocalDate.class, new DateStrategy());
        classMapping.put(LocalTime.class, new TimeStrategy());
        classMapping.put(LocalDateTime.class, new DateTimeStrategy());
        classMapping.put(GradoopId.class, new GradoopIdStrategy());
        classMapping.put(String.class, new StringStrategy());
        classMapping.put(List.class, new ListStrategy());
        classMapping.put(Map.class, new MapStrategy());
        return Collections.unmodifiableMap(classMapping);
    }

    private PropertyValueStrategy[] initByteStrategyMap() {
        PropertyValueStrategy[] byteMapping = new PropertyValueStrategy[this.classStrategyMap.size() + 1];
        Iterator<PropertyValueStrategy> iterator = this.classStrategyMap.values().iterator();
        while (iterator.hasNext()) {
            PropertyValueStrategy strategy;
            byteMapping[strategy.getRawType()] = strategy = iterator.next();
        }
        byteMapping[this.nullStrategy.getRawType()] = this.nullStrategy;
        return byteMapping;
    }
}

