/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import org.gradoop.common.exceptions.UnsupportedTypeException;

class PropertyValueStrategyUtils {
    private static final int SHORT = 0;
    private static final int INT = 1;
    private static final int LONG = 2;
    private static final int FLOAT = 3;
    private static final int DOUBLE = 4;
    private static final int BIG_DECIMAL = 5;

    PropertyValueStrategyUtils() {
    }

    static int compareNumerical(Number aValue, Object other) {
        int result;
        int bType;
        if (!(other instanceof Number)) {
            throw new IllegalArgumentException(String.format("Incompatible types: %s, %s", aValue.getClass(), other.getClass()));
        }
        Number bValue = (Number)other;
        int aType = PropertyValueStrategyUtils.getType(aValue);
        boolean sameType = aType == (bType = PropertyValueStrategyUtils.getType(bValue));
        int maxType = Math.max(aType, bType);
        if (maxType == 0) {
            result = Short.compare(aValue.shortValue(), bValue.shortValue());
        } else if (maxType == 1) {
            int b;
            int a;
            if (sameType) {
                a = aValue.intValue();
                b = bValue.intValue();
            } else {
                a = aType == 1 ? aValue.intValue() : (int)aValue.shortValue();
                b = bType == 1 ? bValue.intValue() : (int)bValue.shortValue();
            }
            result = Integer.compare(a, b);
        } else if (maxType == 3) {
            float b;
            float a;
            if (sameType) {
                a = aValue.floatValue();
                b = bValue.floatValue();
            } else {
                a = aType == 3 ? aValue.floatValue() : PropertyValueStrategyUtils.floatValue(aValue, aType);
                b = bType == 3 ? bValue.floatValue() : PropertyValueStrategyUtils.floatValue(bValue, bType);
            }
            result = Float.compare(a, b);
        } else if (maxType == 2) {
            long b;
            long a;
            if (sameType) {
                a = aValue.longValue();
                b = bValue.longValue();
            } else {
                a = aType == 2 ? aValue.longValue() : PropertyValueStrategyUtils.longValue(aValue, aType);
                b = bType == 2 ? bValue.longValue() : PropertyValueStrategyUtils.longValue(bValue, bType);
            }
            result = Long.compare(a, b);
        } else if (maxType == 4) {
            double b;
            double a;
            if (sameType) {
                a = aValue.doubleValue();
                b = bValue.doubleValue();
            } else {
                a = aType == 4 ? aValue.doubleValue() : PropertyValueStrategyUtils.doubleValue(aValue, aType);
                b = bType == 4 ? bValue.doubleValue() : PropertyValueStrategyUtils.doubleValue(bValue, bType);
            }
            result = Double.compare(a, b);
        } else {
            BigDecimal b;
            BigDecimal a;
            if (sameType) {
                a = (BigDecimal)aValue;
                b = (BigDecimal)bValue;
            } else {
                a = aType == 5 ? (BigDecimal)aValue : PropertyValueStrategyUtils.bigDecimalValue(aValue, aType);
                b = bType == 5 ? (BigDecimal)bValue : PropertyValueStrategyUtils.bigDecimalValue(bValue, bType);
            }
            result = a.compareTo(b);
        }
        return result;
    }

    private static int getType(Number value) {
        int type;
        Preconditions.checkNotNull((Object)value);
        if (value instanceof Short) {
            type = 0;
        } else if (value instanceof Integer) {
            type = 1;
        } else if (value instanceof Long) {
            type = 2;
        } else if (value instanceof Float) {
            type = 3;
        } else if (value instanceof Double) {
            type = 4;
        } else if (value instanceof BigDecimal) {
            type = 5;
        } else {
            throw new UnsupportedTypeException(value.getClass());
        }
        return type;
    }

    private static BigDecimal bigDecimalValue(Number value, int type) {
        switch (type) {
            case 0: {
                return BigDecimal.valueOf(value.shortValue());
            }
            case 1: {
                return BigDecimal.valueOf(value.intValue());
            }
            case 2: {
                return BigDecimal.valueOf(value.longValue());
            }
            case 3: {
                return BigDecimal.valueOf(value.floatValue());
            }
        }
        return BigDecimal.valueOf(value.doubleValue());
    }

    private static double doubleValue(Number value, int type) {
        switch (type) {
            case 0: {
                return value.shortValue();
            }
            case 1: {
                return value.intValue();
            }
            case 2: {
                return value.longValue();
            }
        }
        return value.floatValue();
    }

    private static long longValue(Number value, int type) {
        if (type == 0) {
            return value.shortValue();
        }
        return value.intValue();
    }

    private static float floatValue(Number value, int type) {
        switch (type) {
            case 0: {
                return value.shortValue();
            }
            case 1: {
                return value.intValue();
            }
        }
        return value.longValue();
    }
}

