/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.bytes.Bytes;
import org.gradoop.common.model.impl.properties.strategies.AbstractFixSizedPropertyValueStrategy;
import org.gradoop.common.model.impl.properties.strategies.PropertyValueStrategyUtils;

public class ShortStrategy
extends AbstractFixSizedPropertyValueStrategy<Short> {
    @Override
    public Short read(DataInputView inputView, byte typeByte) throws IOException {
        int length = 2;
        byte[] rawBytes = new byte[length];
        for (int i = 0; i < rawBytes.length; ++i) {
            rawBytes[i] = inputView.readByte();
        }
        return Bytes.toShort(rawBytes);
    }

    @Override
    public int compare(Short value, Object other) {
        return PropertyValueStrategyUtils.compareNumerical(value, other);
    }

    @Override
    public boolean is(Object value) {
        return value instanceof Short;
    }

    @Override
    public Class<Short> getType() {
        return Short.class;
    }

    @Override
    public Short get(byte[] bytes) {
        return Bytes.toShort(bytes, 1);
    }

    @Override
    public byte getRawType() {
        return Type.SHORT.getTypeByte();
    }

    @Override
    public byte[] getRawBytes(Short value) {
        byte[] rawBytes = new byte[3];
        rawBytes[0] = this.getRawType();
        Bytes.putShort(rawBytes, 1, value);
        return rawBytes;
    }
}

