/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.bytes.Bytes;
import org.gradoop.common.model.impl.properties.strategies.AbstractVariableSizedPropertyValueStrategy;

public class StringStrategy
extends AbstractVariableSizedPropertyValueStrategy<String> {
    @Override
    public String read(DataInputView inputView, byte typeByte) throws IOException {
        byte[] rawBytes = this.readVariableSizedData(inputView, typeByte);
        return Bytes.toString(rawBytes);
    }

    @Override
    public int compare(String value, Object other) {
        if (other instanceof String) {
            return value.compareTo((String)other);
        }
        throw new IllegalArgumentException(String.format("Incompatible types: %s, %s", value.getClass(), other.getClass()));
    }

    @Override
    public boolean is(Object value) {
        return value instanceof String;
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public String get(byte[] bytes) {
        return Bytes.toString(bytes, 1, bytes.length - 1);
    }

    @Override
    public byte getRawType() {
        return Type.STRING.getTypeByte();
    }

    @Override
    public byte[] getRawBytes(String value) {
        byte[] valueBytes = Bytes.toBytes(value);
        byte[] rawBytes = new byte[1 + valueBytes.length];
        rawBytes[0] = this.getRawType();
        Bytes.putBytes(rawBytes, 1, valueBytes, 0, valueBytes.length);
        return rawBytes;
    }
}

