/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.model.impl.properties.strategies;

import java.io.IOException;
import java.time.LocalTime;
import java.util.Arrays;
import org.apache.flink.core.memory.DataInputView;
import org.gradoop.common.model.impl.properties.DateTimeSerializer;
import org.gradoop.common.model.impl.properties.Type;
import org.gradoop.common.model.impl.properties.bytes.Bytes;
import org.gradoop.common.model.impl.properties.strategies.AbstractFixSizedPropertyValueStrategy;

public class TimeStrategy
extends AbstractFixSizedPropertyValueStrategy<LocalTime> {
    @Override
    public LocalTime read(DataInputView inputView, byte typeByte) throws IOException {
        int length = 16;
        byte[] rawBytes = new byte[length];
        for (int i = 0; i < rawBytes.length; ++i) {
            rawBytes[i] = inputView.readByte();
        }
        return DateTimeSerializer.deserializeTime(rawBytes);
    }

    @Override
    public int compare(LocalTime value, Object other) {
        if (other instanceof LocalTime) {
            return value.compareTo((LocalTime)other);
        }
        throw new IllegalArgumentException(String.format("Incompatible types: %s, %s", value.getClass(), other.getClass()));
    }

    @Override
    public boolean is(Object value) {
        return value instanceof LocalTime;
    }

    @Override
    public Class<LocalTime> getType() {
        return LocalTime.class;
    }

    @Override
    public LocalTime get(byte[] bytes) {
        return DateTimeSerializer.deserializeTime(Arrays.copyOfRange(bytes, 1, 17));
    }

    @Override
    public byte getRawType() {
        return Type.TIME.getTypeByte();
    }

    @Override
    public byte[] getRawBytes(LocalTime value) {
        byte[] valueBytes = DateTimeSerializer.serializeTime(value);
        byte[] rawBytes = new byte[17];
        rawBytes[0] = this.getRawType();
        Bytes.putBytes(rawBytes, 1, valueBytes, 0, valueBytes.length);
        return rawBytes;
    }
}

