/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.common.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.gradoop.common.model.api.entities.ElementFactoryProvider;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.id.GradoopIdSet;
import org.gradoop.common.model.impl.properties.Properties;
import org.s1ck.gdl.GDLHandler;
import org.s1ck.gdl.model.Edge;
import org.s1ck.gdl.model.Graph;
import org.s1ck.gdl.model.GraphElement;
import org.s1ck.gdl.model.Vertex;

public class AsciiGraphLoader<G extends GraphHead, V extends org.gradoop.common.model.api.entities.Vertex, E extends org.gradoop.common.model.api.entities.Edge> {
    private final ElementFactoryProvider<G, V, E> elementFactoryProvider;
    private final GDLHandler gdlHandler;
    private final Map<GradoopId, G> graphHeads;
    private final Map<Long, GradoopId> graphHeadIds;
    private final Map<GradoopId, V> vertices;
    private final Map<Long, GradoopId> vertexIds;
    private final Map<GradoopId, E> edges;
    private final Map<Long, GradoopId> edgeIds;
    private final Map<String, G> graphHeadCache;
    private final Map<String, V> vertexCache;
    private final Map<String, E> edgeCache;

    private AsciiGraphLoader(GDLHandler gdlHandler, ElementFactoryProvider<G, V, E> elementFactoryProvider) {
        this.gdlHandler = gdlHandler;
        this.elementFactoryProvider = elementFactoryProvider;
        this.graphHeads = Maps.newHashMap();
        this.vertices = Maps.newHashMap();
        this.edges = Maps.newHashMap();
        this.graphHeadIds = Maps.newHashMap();
        this.vertexIds = Maps.newHashMap();
        this.edgeIds = Maps.newHashMap();
        this.graphHeadCache = Maps.newHashMap();
        this.vertexCache = Maps.newHashMap();
        this.edgeCache = Maps.newHashMap();
        this.init();
    }

    public static <G extends GraphHead, V extends org.gradoop.common.model.api.entities.Vertex, E extends org.gradoop.common.model.api.entities.Edge> AsciiGraphLoader<G, V, E> fromString(String asciiGraph, ElementFactoryProvider<G, V, E> elementFactoryProvider) {
        return new AsciiGraphLoader<G, V, E>(new GDLHandler.Builder().setDefaultGraphLabel("").setDefaultVertexLabel("").setDefaultEdgeLabel("").buildFromString(asciiGraph), elementFactoryProvider);
    }

    public static <G extends GraphHead, V extends org.gradoop.common.model.api.entities.Vertex, E extends org.gradoop.common.model.api.entities.Edge> AsciiGraphLoader<G, V, E> fromFile(String fileName, ElementFactoryProvider<G, V, E> elementFactoryProvider) throws IOException {
        return new AsciiGraphLoader<G, V, E>(new GDLHandler.Builder().setDefaultGraphLabel("").setDefaultVertexLabel("").setDefaultEdgeLabel("").buildFromFile(fileName), elementFactoryProvider);
    }

    public static <G extends GraphHead, V extends org.gradoop.common.model.api.entities.Vertex, E extends org.gradoop.common.model.api.entities.Edge> AsciiGraphLoader<G, V, E> fromStream(InputStream inputStream, ElementFactoryProvider<G, V, E> elementFactoryProvider) throws IOException {
        return new AsciiGraphLoader<G, V, E>(new GDLHandler.Builder().setDefaultGraphLabel("").setDefaultVertexLabel("").setDefaultEdgeLabel("").buildFromStream(inputStream), elementFactoryProvider);
    }

    public void appendFromString(String asciiGraph) {
        this.gdlHandler.append(asciiGraph);
        this.init();
    }

    public Collection<G> getGraphHeads() {
        return new ImmutableSet.Builder().addAll(this.graphHeads.values()).build();
    }

    public G getGraphHeadByVariable(String variable) {
        return (G)((GraphHead)this.getGraphHeadCache().get(variable));
    }

    public Collection<G> getGraphHeadsByVariables(String ... variables) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)variables.length);
        for (String variable : variables) {
            G graphHead = this.getGraphHeadByVariable(variable);
            if (graphHead == null) continue;
            result.add(graphHead);
        }
        return result;
    }

    public Collection<V> getVertices() {
        return new ImmutableSet.Builder().addAll(this.vertices.values()).build();
    }

    public V getVertexByVariable(String variable) {
        return (V)((org.gradoop.common.model.api.entities.Vertex)this.vertexCache.get(variable));
    }

    public Collection<V> getVerticesByVariables(String ... variables) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)variables.length);
        for (String variable : variables) {
            V vertex = this.getVertexByVariable(variable);
            if (vertex == null) continue;
            result.add(vertex);
        }
        return result;
    }

    public Collection<V> getVerticesByGraphIds(GradoopIdSet graphIds) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)graphIds.size());
        for (org.gradoop.common.model.api.entities.Vertex vertex : this.vertices.values()) {
            if (!vertex.getGraphIds().containsAny(graphIds)) continue;
            result.add(vertex);
        }
        return result;
    }

    public Collection<V> getVerticesByGraphVariables(String ... graphVariables) {
        GradoopIdSet graphIds = new GradoopIdSet();
        for (GraphHead graphHead : this.getGraphHeadsByVariables(graphVariables)) {
            graphIds.add(graphHead.getId());
        }
        return this.getVerticesByGraphIds(graphIds);
    }

    public Collection<E> getEdges() {
        return new ImmutableSet.Builder().addAll(this.edges.values()).build();
    }

    public E getEdgeByVariable(String variable) {
        return (E)((org.gradoop.common.model.api.entities.Edge)this.edgeCache.get(variable));
    }

    public Collection<E> getEdgesByVariables(String ... variables) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)variables.length);
        for (String variable : variables) {
            org.gradoop.common.model.api.entities.Edge edge = (org.gradoop.common.model.api.entities.Edge)this.edgeCache.get(variable);
            if (edge == null) continue;
            result.add(edge);
        }
        return result;
    }

    public Collection<E> getEdgesByGraphIds(GradoopIdSet graphIds) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)graphIds.size());
        for (org.gradoop.common.model.api.entities.Edge edge : this.edges.values()) {
            if (!edge.getGraphIds().containsAny(graphIds)) continue;
            result.add(edge);
        }
        return result;
    }

    public Collection<E> getEdgesByGraphVariables(String ... variables) {
        GradoopIdSet graphIds = new GradoopIdSet();
        for (GraphHead graphHead : this.getGraphHeadsByVariables(variables)) {
            graphIds.add(graphHead.getId());
        }
        return this.getEdgesByGraphIds(graphIds);
    }

    public Map<String, G> getGraphHeadCache() {
        return new ImmutableMap.Builder().putAll(this.graphHeadCache).build();
    }

    public Map<String, V> getVertexCache() {
        return new ImmutableMap.Builder().putAll(this.vertexCache).build();
    }

    public Map<String, E> getEdgeCache() {
        return new ImmutableMap.Builder().putAll(this.edgeCache).build();
    }

    private void init() {
        this.initGraphHeads();
        this.initVertices();
        this.initEdges();
    }

    private void initGraphHeads() {
        for (Graph graph : this.gdlHandler.getGraphs()) {
            if (this.graphHeadIds.containsKey(graph.getId())) continue;
            this.initGraphHead(graph);
        }
        for (Map.Entry entry : this.gdlHandler.getGraphCache().entrySet()) {
            this.updateGraphCache((String)entry.getKey(), (Graph)entry.getValue());
        }
    }

    private void initVertices() {
        for (Vertex vertex : this.gdlHandler.getVertices()) {
            this.initVertex(vertex);
        }
        for (Map.Entry entry : this.gdlHandler.getVertexCache().entrySet()) {
            this.updateVertexCache((String)entry.getKey(), (Vertex)entry.getValue());
        }
    }

    private void initEdges() {
        for (Edge edge : this.gdlHandler.getEdges()) {
            this.initEdge(edge);
        }
        for (Map.Entry entry : this.gdlHandler.getEdgeCache().entrySet()) {
            this.updateEdgeCache((String)entry.getKey(), (Edge)entry.getValue());
        }
    }

    private G initGraphHead(Graph g) {
        G graphHead = this.elementFactoryProvider.getGraphHeadFactory().createGraphHead(g.getLabel(), Properties.createFromMap(g.getProperties()));
        this.graphHeadIds.put(g.getId(), graphHead.getId());
        this.graphHeads.put(graphHead.getId(), graphHead);
        return graphHead;
    }

    private V initVertex(Vertex v) {
        org.gradoop.common.model.api.entities.Vertex vertex;
        if (!this.vertexIds.containsKey(v.getId())) {
            vertex = this.elementFactoryProvider.getVertexFactory().createVertex(v.getLabel(), Properties.createFromMap(v.getProperties()), this.createGradoopIdSet((GraphElement)v));
            this.vertexIds.put(v.getId(), vertex.getId());
            this.vertices.put(vertex.getId(), vertex);
        } else {
            vertex = (org.gradoop.common.model.api.entities.Vertex)this.vertices.get(this.vertexIds.get(v.getId()));
            vertex.setGraphIds(this.createGradoopIdSet((GraphElement)v));
        }
        return (V)vertex;
    }

    private E initEdge(Edge e) {
        org.gradoop.common.model.api.entities.Edge edge;
        if (!this.edgeIds.containsKey(e.getId())) {
            edge = this.elementFactoryProvider.getEdgeFactory().createEdge(e.getLabel(), this.vertexIds.get(e.getSourceVertexId()), this.vertexIds.get(e.getTargetVertexId()), Properties.createFromMap(e.getProperties()), this.createGradoopIdSet((GraphElement)e));
            this.edgeIds.put(e.getId(), edge.getId());
            this.edges.put(edge.getId(), edge);
        } else {
            edge = (org.gradoop.common.model.api.entities.Edge)this.edges.get(this.edgeIds.get(e.getId()));
            edge.setGraphIds(this.createGradoopIdSet((GraphElement)e));
        }
        return (E)edge;
    }

    private void updateGraphCache(String variable, Graph g) {
        this.graphHeadCache.put(variable, this.graphHeads.get(this.graphHeadIds.get(g.getId())));
    }

    private void updateVertexCache(String variable, Vertex v) {
        this.vertexCache.put(variable, this.vertices.get(this.vertexIds.get(v.getId())));
    }

    private void updateEdgeCache(String variable, Edge e) {
        this.edgeCache.put(variable, this.edges.get(this.edgeIds.get(e.getId())));
    }

    private GradoopIdSet createGradoopIdSet(GraphElement e) {
        GradoopIdSet result = new GradoopIdSet();
        for (Long graphId : e.getGraphs()) {
            result.add(this.graphHeadIds.get(graphId));
        }
        return result;
    }
}

