/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.btgs;

import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.spargel.GatherFunction;
import org.apache.flink.graph.spargel.ScatterFunction;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.btgs.functions.BtgMessenger;
import org.gradoop.flink.algorithms.btgs.functions.BtgUpdater;
import org.gradoop.flink.algorithms.btgs.functions.CollectGradoopIds;
import org.gradoop.flink.algorithms.btgs.functions.ComponentToNewBtgId;
import org.gradoop.flink.algorithms.btgs.functions.MasterData;
import org.gradoop.flink.algorithms.btgs.functions.NewBtgGraphHead;
import org.gradoop.flink.algorithms.btgs.functions.SetBtgId;
import org.gradoop.flink.algorithms.btgs.functions.SetBtgIds;
import org.gradoop.flink.algorithms.btgs.functions.TargetIdBtgId;
import org.gradoop.flink.algorithms.btgs.functions.TransactionalData;
import org.gradoop.flink.algorithms.gelly.functions.VertexToGellyVertexWithGradoopId;
import org.gradoop.flink.model.api.operators.UnaryGraphToCollectionOperator;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.ExpandGradoopIds;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.epgm.ToGellyEdgeWithNullValue;
import org.gradoop.flink.model.impl.functions.tuple.SwitchPair;
import org.gradoop.flink.model.impl.functions.tuple.Value0Of2;
import org.gradoop.flink.model.impl.functions.utils.LeftSide;

public class BusinessTransactionGraphs
implements UnaryGraphToCollectionOperator {
    public static final String SUPERTYPE_KEY = "superType";
    public static final String SUPERCLASS_VALUE_MASTER = "M";
    public static final String SUPERCLASS_VALUE_TRANSACTIONAL = "T";
    public static final String BTG_LABEL = "BusinessTransactionGraph";
    public static final String SOURCEID_KEY = "sid";

    @Override
    public GraphCollection execute(LogicalGraph iig) {
        FilterOperator masterVertices = iig.getVertices().filter(new MasterData());
        LogicalGraph transGraph = (LogicalGraph)iig.vertexInducedSubgraph(new TransactionalData());
        JoinOperator.EquiJoin transVertices = transGraph.getVertices();
        MapOperator transEdges = transGraph.getEdges().map((MapFunction)new ToGellyEdgeWithNullValue());
        Graph gellyTransGraph = Graph.fromDataSet((DataSet)transVertices.map((MapFunction)new VertexToGellyVertexWithGradoopId()), (DataSet)transEdges, (ExecutionEnvironment)iig.getConfig().getExecutionEnvironment());
        gellyTransGraph = gellyTransGraph.getUndirected().runScatterGatherIteration((ScatterFunction)new BtgMessenger(), (GatherFunction)new BtgUpdater(), 100);
        MapOperator btgVerticesMap = gellyTransGraph.getVerticesAsTuple2().map(new SwitchPair()).groupBy(new int[]{0}).reduceGroup((GroupReduceFunction)new CollectGradoopIds()).map((MapFunction)new ComponentToNewBtgId());
        MapOperator vertexBtgMap = btgVerticesMap.flatMap(new ExpandGradoopIds()).map(new SwitchPair());
        MapOperator graphHeads = btgVerticesMap.map(new Value0Of2()).map(new NewBtgGraphHead(iig.getFactory().getGraphHeadFactory()));
        JoinOperator.EquiJoin btgEdges = iig.getEdges().join((DataSet)vertexBtgMap).where(new SourceId()).equalTo(new int[]{0}).with(new SetBtgId());
        transVertices = transVertices.join((DataSet)vertexBtgMap).where(new Id()).equalTo(new int[]{0}).with(new SetBtgId());
        vertexBtgMap = btgEdges.map(new TargetIdBtgId()).join((DataSet)masterVertices).where(new int[]{0}).equalTo(new Id()).with(new LeftSide()).distinct();
        GroupReduceOperator vertexBtgsMap = vertexBtgMap.groupBy(new int[]{0}).reduceGroup((GroupReduceFunction)new CollectGradoopIds());
        masterVertices = masterVertices.join((DataSet)vertexBtgsMap).where(new Id()).equalTo(new int[]{0}).with(new SetBtgIds());
        return iig.getCollectionFactory().fromDataSets((DataSet<EPGMGraphHead>)graphHeads, (DataSet<EPGMVertex>)transVertices.union((DataSet)masterVertices), (DataSet<EPGMEdge>)btgEdges);
    }
}

