/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.btgs.functions;

import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.id.GradoopIdSet;

public class CollectGradoopIds
implements GroupCombineFunction<Tuple2<GradoopId, GradoopIdSet>, Tuple2<GradoopId, GradoopIdSet>>,
GroupReduceFunction<Tuple2<GradoopId, GradoopId>, Tuple2<GradoopId, GradoopIdSet>> {
    public void reduce(Iterable<Tuple2<GradoopId, GradoopId>> mappings, Collector<Tuple2<GradoopId, GradoopIdSet>> collector) throws Exception {
        boolean first = true;
        GradoopId vertexId = null;
        GradoopIdSet btgIds = new GradoopIdSet();
        for (Tuple2<GradoopId, GradoopId> pair : mappings) {
            if (first) {
                vertexId = (GradoopId)pair.f0;
                first = false;
            }
            btgIds.add((GradoopId)pair.f1);
        }
        collector.collect((Object)new Tuple2(vertexId, (Object)btgIds));
    }

    public void combine(Iterable<Tuple2<GradoopId, GradoopIdSet>> mappings, Collector<Tuple2<GradoopId, GradoopIdSet>> collector) {
        boolean first = true;
        GradoopId vertexId = null;
        GradoopIdSet btgIds = null;
        for (Tuple2<GradoopId, GradoopIdSet> pair : mappings) {
            if (first) {
                vertexId = (GradoopId)pair.f0;
                btgIds = (GradoopIdSet)pair.f1;
                first = false;
            }
            btgIds.addAll((GradoopIdSet)pair.f1);
        }
        collector.collect((Object)new Tuple2(vertexId, btgIds));
    }
}

