/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.flink.algorithms.fsm.dimspan.DIMSpan;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DIMSpanConfig;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.conversion.EPGMGraphTransactionToLabeledGraph;
import org.gradoop.flink.algorithms.fsm.dimspan.tuples.LabeledGraphStringString;
import org.gradoop.flink.model.api.operators.UnaryCollectionToCollectionOperator;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class TransactionalFSM
implements UnaryCollectionToCollectionOperator {
    private final DIMSpan dimSpan;

    public TransactionalFSM(float minSupport) {
        DIMSpanConfig fsmConfig = new DIMSpanConfig(minSupport, true);
        this.dimSpan = new DIMSpan(fsmConfig);
    }

    public TransactionalFSM(DIMSpanConfig fsmConfig) {
        this.dimSpan = new DIMSpan(fsmConfig);
    }

    @Override
    public GraphCollection execute(GraphCollection collection) {
        MapOperator input = collection.getGraphTransactions().map((MapFunction)new EPGMGraphTransactionToLabeledGraph());
        DataSet<GraphTransaction> output = this.dimSpan.execute((DataSet<LabeledGraphStringString>)input);
        return collection.getFactory().fromTransactions(output);
    }

    @Override
    public String getName() {
        return DIMSpan.class.getSimpleName();
    }
}

