/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.aggregation.AggregationFunction;
import org.apache.flink.api.java.aggregation.SumAggregationFunction;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.flink.algorithms.fsm.dimspan.comparison.AlphabeticalLabelComparator;
import org.gradoop.flink.algorithms.fsm.dimspan.comparison.InverseProportionalLabelComparator;
import org.gradoop.flink.algorithms.fsm.dimspan.comparison.LabelComparator;
import org.gradoop.flink.algorithms.fsm.dimspan.comparison.ProportionalLabelComparator;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DIMSpanConfig;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DataflowStep;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DictionaryType;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.conversion.DFSCodeToEPGMGraphTransaction;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.mining.CompressPattern;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.mining.CreateCollector;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.mining.ExpandFrequentPatterns;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.mining.Frequent;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.mining.GrowFrequentPatterns;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.mining.InitSingleEdgePatternEmbeddingsMap;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.mining.IsFrequentPatternCollector;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.mining.NotObsolete;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.mining.ReportSupportedPatterns;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.mining.VerifyPattern;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.preprocessing.AggregateMultipleFunctions;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.preprocessing.CreateDictionary;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.preprocessing.EncodeAndPruneEdges;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.preprocessing.EncodeAndPruneVertices;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.preprocessing.MinFrequency;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.preprocessing.NotEmpty;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.preprocessing.ReportEdgeLabels;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.preprocessing.ReportVertexLabels;
import org.gradoop.flink.algorithms.fsm.dimspan.gspan.DirectedGSpanLogic;
import org.gradoop.flink.algorithms.fsm.dimspan.gspan.GSpanLogic;
import org.gradoop.flink.algorithms.fsm.dimspan.gspan.UndirectedGSpanLogic;
import org.gradoop.flink.algorithms.fsm.dimspan.tuples.LabeledGraphIntString;
import org.gradoop.flink.algorithms.fsm.dimspan.tuples.LabeledGraphStringString;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.model.impl.operators.count.Count;
import org.gradoop.flink.model.impl.tuples.WithCount;

public class DIMSpan {
    private static final int MAX_ITERATIONS = 100;
    protected final DIMSpanConfig fsmConfig;
    protected DataSet<Long> graphCount;
    protected DataSet<Long> minFrequency;
    protected final GSpanLogic gSpan;
    private DataSet<String[]> vertexDictionary;
    private DataSet<String[]> edgeDictionary;
    private final LabelComparator comparator;

    public DIMSpan(DIMSpanConfig fsmConfig) {
        this.fsmConfig = fsmConfig;
        GSpanLogic gSpanLogic = this.gSpan = fsmConfig.isDirected() ? new DirectedGSpanLogic(fsmConfig) : new UndirectedGSpanLogic(fsmConfig);
        this.comparator = fsmConfig.getDictionaryType() == DictionaryType.PROPORTIONAL ? new ProportionalLabelComparator() : (fsmConfig.getDictionaryType() == DictionaryType.INVERSE_PROPORTIONAL ? new InverseProportionalLabelComparator() : new AlphabeticalLabelComparator());
    }

    public DataSet<GraphTransaction> execute(DataSet<LabeledGraphStringString> input) {
        DataSet<int[]> encodedInput = this.preProcess(input);
        DataSet<WithCount<int[]>> encodedOutput = this.mine(encodedInput);
        return this.postProcess(encodedOutput);
    }

    private DataSet<int[]> preProcess(DataSet<LabeledGraphStringString> graphs) {
        this.graphCount = Count.count(graphs);
        this.minFrequency = this.graphCount.map((MapFunction)new MinFrequency(this.fsmConfig));
        DataSet<LabeledGraphIntString> graphsWithEncodedVertices = this.encodeVertices(graphs);
        DataSet<int[]> encodedGraphs = this.encodeEdges(graphsWithEncodedVertices);
        return encodedGraphs.filter((FilterFunction)new NotEmpty());
    }

    protected DataSet<WithCount<int[]>> mine(DataSet<int[]> graphs) {
        MapOperator searchSpace = graphs.map((MapFunction)new InitSingleEdgePatternEmbeddingsMap(this.gSpan, this.fsmConfig));
        MapOperator collector = graphs.getExecutionEnvironment().fromElements((Object[])new Boolean[]{true}).map((MapFunction)new CreateCollector());
        searchSpace = searchSpace.union((DataSet)collector);
        IterativeDataSet iterative = searchSpace.iterate(100);
        FlatMapOperator reports = iterative.flatMap((FlatMapFunction)new ReportSupportedPatterns());
        DataSet<WithCount<int[]>> frequentPatterns = this.getFrequentPatterns((DataSet<WithCount<int[]>>)reports);
        FilterOperator grownEmbeddings = ((MapOperator)iterative.map((MapFunction)new GrowFrequentPatterns(this.gSpan, this.fsmConfig)).withBroadcastSet(frequentPatterns, "fp")).filter((FilterFunction)new NotObsolete());
        return iterative.closeWith((DataSet)grownEmbeddings, frequentPatterns).filter((FilterFunction)new IsFrequentPatternCollector()).flatMap((FlatMapFunction)new ExpandFrequentPatterns());
    }

    private DataSet<GraphTransaction> postProcess(DataSet<WithCount<int[]>> encodedOutput) {
        return ((MapOperator)((MapOperator)encodedOutput.map((MapFunction)new DFSCodeToEPGMGraphTransaction(this.fsmConfig)).withBroadcastSet(this.vertexDictionary, "vld")).withBroadcastSet(this.edgeDictionary, "eld")).withBroadcastSet(this.graphCount, "|G|");
    }

    private DataSet<LabeledGraphIntString> encodeVertices(DataSet<LabeledGraphStringString> graphs) {
        DataSet<WithCount<String>> vertexLabels = graphs.flatMap((FlatMapFunction)new ReportVertexLabels());
        vertexLabels = this.getFrequentLabels(vertexLabels);
        this.vertexDictionary = vertexLabels.reduceGroup((GroupReduceFunction)new CreateDictionary(this.comparator));
        return graphs.map((MapFunction)new EncodeAndPruneVertices()).withBroadcastSet(this.vertexDictionary, "vld");
    }

    private DataSet<int[]> encodeEdges(DataSet<LabeledGraphIntString> graphs) {
        DataSet<WithCount<String>> edgeLabels = graphs.flatMap((FlatMapFunction)new ReportEdgeLabels());
        edgeLabels = this.getFrequentLabels(edgeLabels);
        this.edgeDictionary = edgeLabels.reduceGroup((GroupReduceFunction)new CreateDictionary(this.comparator));
        return graphs.map((MapFunction)new EncodeAndPruneEdges(this.fsmConfig)).withBroadcastSet(this.edgeDictionary, "eld");
    }

    private DataSet<WithCount<String>> getFrequentLabels(DataSet<WithCount<String>> labels) {
        labels = this.fsmConfig.getDictionaryType() != DictionaryType.RANDOM ? labels.groupBy(new int[]{0}).sum(1).filter(new Frequent()).withBroadcastSet(this.minFrequency, "fmin") : labels.distinct();
        return labels;
    }

    private DataSet<WithCount<int[]>> getFrequentPatterns(DataSet<WithCount<int[]>> patterns) {
        patterns = patterns.groupBy(new int[]{0}).combineGroup(this.sumPartition());
        if (this.fsmConfig.getPatternVerificationInStep() == DataflowStep.COMBINE) {
            patterns = patterns.filter((FilterFunction)new VerifyPattern(this.gSpan, this.fsmConfig));
        }
        if (this.fsmConfig.getPatternCompressionInStep() == DataflowStep.COMBINE) {
            patterns = patterns.map((MapFunction)new CompressPattern());
        }
        patterns = patterns.groupBy(new int[]{0}).sum(1);
        patterns = patterns.filter(new Frequent()).withBroadcastSet(this.minFrequency, "fmin");
        if (this.fsmConfig.getPatternVerificationInStep() == DataflowStep.FILTER) {
            patterns = patterns.filter((FilterFunction)new VerifyPattern(this.gSpan, this.fsmConfig));
        }
        if (this.fsmConfig.getPatternCompressionInStep() == DataflowStep.FILTER) {
            patterns = patterns.map((MapFunction)new CompressPattern());
        }
        return patterns;
    }

    private GroupCombineFunction<WithCount<int[]>, WithCount<int[]>> sumPartition() {
        AggregationFunction[] sum = new AggregationFunction[]{new SumAggregationFunction.SumAggregationFunctionFactory().createAggregationFunction(Long.class)};
        int[] fields = new int[]{1};
        return new AggregateMultipleFunctions(sum, fields);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

