/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.comparison;

import java.io.Serializable;
import java.util.Comparator;
import org.gradoop.flink.algorithms.fsm.dimspan.model.DFSCodeUtils;

public class DFSCodeComparator
implements Comparator<int[]>,
Serializable {
    private final DFSCodeUtils dfsCodeUtils = new DFSCodeUtils();

    @Override
    public int compare(int[] a, int[] b) {
        int comparison;
        boolean thatIsRoot;
        boolean thisIsRoot = a.length == 0;
        boolean bl = thatIsRoot = b.length == 0;
        if (thisIsRoot && !thatIsRoot) {
            comparison = -1;
        } else if (thatIsRoot && !thisIsRoot) {
            comparison = 1;
        } else {
            int thatSize;
            comparison = 0;
            int thisSize = this.dfsCodeUtils.getEdgeCount(a);
            boolean sameSize = thisSize == (thatSize = this.dfsCodeUtils.getEdgeCount(b));
            int minSize = sameSize || thisSize < thatSize ? thisSize : thatSize;
            for (int edgeTime = 0; edgeTime < minSize; ++edgeTime) {
                int thisFromTime = this.dfsCodeUtils.getFromId(a, edgeTime);
                int thatFromTime = this.dfsCodeUtils.getFromId(b, edgeTime);
                int thisToTime = this.dfsCodeUtils.getToId(a, edgeTime);
                int thatToTime = this.dfsCodeUtils.getToId(b, edgeTime);
                if (thisFromTime == thatFromTime && thisToTime == thatToTime) {
                    int thatFromLabel;
                    int thisFromLabel = this.dfsCodeUtils.getFromLabel(a, edgeTime);
                    comparison = thisFromLabel - (thatFromLabel = this.dfsCodeUtils.getFromLabel(b, edgeTime));
                    if (comparison == 0) {
                        boolean thisIsOutgoing = this.dfsCodeUtils.isOutgoing(a, edgeTime);
                        boolean thatIsOutgoing = this.dfsCodeUtils.isOutgoing(b, edgeTime);
                        if (thisIsOutgoing && !thatIsOutgoing) {
                            comparison = -1;
                        } else if (thatIsOutgoing && !thisIsOutgoing) {
                            comparison = 1;
                        } else {
                            int thatEdgeLabel;
                            int thisEdgeLabel = this.dfsCodeUtils.getEdgeLabel(a, edgeTime);
                            comparison = thisEdgeLabel - (thatEdgeLabel = this.dfsCodeUtils.getEdgeLabel(b, edgeTime));
                            if (comparison == 0) {
                                int thisToLabel = this.dfsCodeUtils.getToLabel(a, edgeTime);
                                int thatToLabel = this.dfsCodeUtils.getToLabel(b, edgeTime);
                                comparison = thisToLabel - thatToLabel;
                            }
                        }
                    }
                } else {
                    boolean thatIsBackwards;
                    boolean thisIsBackwards = thisToTime <= thisFromTime;
                    boolean bl2 = thatIsBackwards = thatToTime <= thatFromTime;
                    comparison = thisIsBackwards && !thatIsBackwards ? -1 : (thatIsBackwards && !thisIsBackwards ? 1 : (thatIsBackwards ? thisToTime - thatToTime : thatFromTime - thisFromTime));
                }
                if (comparison != 0) break;
            }
            if (comparison == 0 && !sameSize) {
                comparison = thisSize > thatSize ? 1 : -1;
            }
        }
        return comparison;
    }
}

