/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.config;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DataflowStep;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DictionaryType;

public class DIMSpanConfig
implements Serializable {
    private float minSupport = 1.0f;
    private boolean directed = true;
    private DictionaryType dictionaryType = DictionaryType.INVERSE_PROPORTIONAL;
    private boolean embeddingCompressionEnabled = true;
    private boolean graphCompressionEnabled = true;
    private DataflowStep patternCompressionInStep = DataflowStep.MAP;
    private DataflowStep patternVerificationInStep = DataflowStep.COMBINE;
    private boolean branchConstraintEnabled = true;

    public DIMSpanConfig(float minSupport, boolean directed) {
        this.minSupport = minSupport;
        this.directed = directed;
    }

    public String toString() {
        ArrayList parameters = Lists.newArrayList();
        parameters.add("s_min : " + this.minSupport);
        parameters.add((this.directed ? "directed" : "undirected") + " mode");
        parameters.add("dictionary type : " + this.dictionaryType.toString());
        parameters.add(this.getParameterEnabled("branch constraint", this.branchConstraintEnabled));
        parameters.add(this.getParameterEnabled("graph compression", this.graphCompressionEnabled));
        parameters.add(this.getParameterEnabled("embedding compression", this.embeddingCompressionEnabled));
        parameters.add("pattern compression @ " + this.patternCompressionInStep.toString());
        parameters.add("pattern validation @ " + this.patternVerificationInStep.toString());
        return StringUtils.join((Iterable)parameters, (String)"|");
    }

    private String getParameterEnabled(String parameter, boolean enabled) {
        return parameter + " " + (enabled ? "enabled" : "disabled");
    }

    public float getMinSupport() {
        return this.minSupport;
    }

    public void setMinSupport(float minSupport) {
        this.minSupport = minSupport;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public void setDirected(boolean directed) {
        this.directed = directed;
    }

    public DictionaryType getDictionaryType() {
        return this.dictionaryType;
    }

    public void setDictionaryType(DictionaryType dictionaryType) {
        this.dictionaryType = dictionaryType;
    }

    public boolean isEmbeddingCompressionEnabled() {
        return this.embeddingCompressionEnabled;
    }

    public void setEmbeddingCompressionEnabled(boolean embeddingCompressionEnabled) {
        this.embeddingCompressionEnabled = embeddingCompressionEnabled;
    }

    public boolean isGraphCompressionEnabled() {
        return this.graphCompressionEnabled;
    }

    public void setGraphCompressionEnabled(boolean graphCompressionEnabled) {
        this.graphCompressionEnabled = graphCompressionEnabled;
    }

    public void setPatternCompressionInStep(DataflowStep patternCompressionInStep) {
        this.patternCompressionInStep = patternCompressionInStep;
    }

    public DataflowStep getPatternCompressionInStep() {
        return this.patternCompressionInStep;
    }

    public DataflowStep getPatternVerificationInStep() {
        return this.patternVerificationInStep;
    }

    public void setPatternVerificationInStep(DataflowStep patternVerificationInStep) {
        this.patternVerificationInStep = patternVerificationInStep;
    }

    public void setBranchConstraintEnabled(boolean branchConstraintEnabled) {
        this.branchConstraintEnabled = branchConstraintEnabled;
    }

    public boolean isBranchConstraintEnabled() {
        return this.branchConstraintEnabled;
    }
}

