/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.functions.conversion;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.id.GradoopIdSet;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DIMSpanConfig;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DataflowStep;
import org.gradoop.flink.algorithms.fsm.dimspan.model.GraphUtils;
import org.gradoop.flink.algorithms.fsm.dimspan.model.GraphUtilsBase;
import org.gradoop.flink.algorithms.fsm.dimspan.model.Simple16Compressor;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.model.impl.tuples.WithCount;

public class DFSCodeToEPGMGraphTransaction
extends RichMapFunction<WithCount<int[]>, GraphTransaction> {
    private final boolean uncompressPatterns;
    private String[] vertexDictionary;
    private String[] edgeDictionary;
    private final GraphUtils graphUtils = new GraphUtilsBase();
    private long graphCount;

    public DFSCodeToEPGMGraphTransaction(DIMSpanConfig fsmConfig) {
        this.uncompressPatterns = !fsmConfig.getPatternCompressionInStep().equals(DataflowStep.WITHOUT);
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.vertexDictionary = (String[])this.getRuntimeContext().getBroadcastVariable("vld").get(0);
        this.edgeDictionary = (String[])this.getRuntimeContext().getBroadcastVariable("eld").get(0);
        this.graphCount = (Long)this.getRuntimeContext().getBroadcastVariable("|G|").get(0);
    }

    public GraphTransaction map(WithCount<int[]> patternWithCount) throws Exception {
        int[] pattern = patternWithCount.getObject();
        if (this.uncompressPatterns) {
            pattern = Simple16Compressor.uncompress(pattern);
        }
        long frequency = patternWithCount.getCount();
        EPGMGraphHead graphHead = new EPGMGraphHead(GradoopId.get(), "", null);
        graphHead.setLabel("FrequentPattern");
        graphHead.setProperty("support", (Object)Float.valueOf((float)frequency / (float)this.graphCount));
        GradoopIdSet graphIds = GradoopIdSet.fromExisting((GradoopId[])new GradoopId[]{graphHead.getId()});
        int[] vertexLabels = this.graphUtils.getVertexLabels(pattern);
        GradoopId[] vertexIds = new GradoopId[vertexLabels.length];
        HashSet vertices = Sets.newHashSetWithExpectedSize((int)vertexLabels.length);
        int intId = 0;
        for (int intLabel : vertexLabels) {
            String label = this.vertexDictionary[intLabel];
            GradoopId gradoopId = GradoopId.get();
            vertices.add(new EPGMVertex(gradoopId, label, null, graphIds));
            vertexIds[intId] = gradoopId;
            ++intId;
        }
        HashSet edges = Sets.newHashSet();
        for (int edgeId = 0; edgeId < this.graphUtils.getEdgeCount(pattern); ++edgeId) {
            GradoopId targetId;
            GradoopId sourceId;
            String label = this.edgeDictionary[this.graphUtils.getEdgeLabel(pattern, edgeId)];
            if (this.graphUtils.isOutgoing(pattern, edgeId)) {
                sourceId = vertexIds[this.graphUtils.getFromId(pattern, edgeId)];
                targetId = vertexIds[this.graphUtils.getToId(pattern, edgeId)];
            } else {
                sourceId = vertexIds[this.graphUtils.getToId(pattern, edgeId)];
                targetId = vertexIds[this.graphUtils.getFromId(pattern, edgeId)];
            }
            edges.add(new EPGMEdge(GradoopId.get(), label, sourceId, targetId, null, graphIds));
        }
        return new GraphTransaction(graphHead, vertices, edges);
    }
}

