/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.functions.conversion;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.flink.api.common.functions.MapFunction;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.fsm.dimspan.tuples.LabeledGraphStringString;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class EPGMGraphTransactionToLabeledGraph
implements MapFunction<GraphTransaction, LabeledGraphStringString> {
    public LabeledGraphStringString map(GraphTransaction transaction) throws Exception {
        LabeledGraphStringString outGraph = LabeledGraphStringString.getEmptyOne();
        HashMap labelMap = Maps.newHashMap();
        HashMap vertexIdMap = Maps.newHashMap();
        for (EPGMVertex vertex : transaction.getVertices()) {
            vertexIdMap.put(vertex.getId(), outGraph.addVertex(vertex.getLabel()));
        }
        labelMap.clear();
        for (EPGMEdge edge : transaction.getEdges()) {
            int sourceId = (Integer)vertexIdMap.get(edge.getSourceId());
            int targetId = (Integer)vertexIdMap.get(edge.getTargetId());
            outGraph.addEdge(sourceId, edge.getLabel(), targetId);
        }
        return outGraph;
    }
}

