/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.functions.mining;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.flink.algorithms.fsm.dimspan.comparison.DFSCodeComparator;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DIMSpanConfig;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DataflowStep;
import org.gradoop.flink.algorithms.fsm.dimspan.gspan.GSpanLogic;
import org.gradoop.flink.algorithms.fsm.dimspan.model.Simple16Compressor;
import org.gradoop.flink.algorithms.fsm.dimspan.tuples.GraphWithPatternEmbeddingsMap;
import org.gradoop.flink.algorithms.fsm.dimspan.tuples.PatternEmbeddingsMap;
import org.gradoop.flink.model.impl.tuples.WithCount;

public class GrowFrequentPatterns
extends RichMapFunction<GraphWithPatternEmbeddingsMap, GraphWithPatternEmbeddingsMap> {
    private List<int[]> compressedFrequentPatterns;
    private List<int[]> frequentPatterns;
    private List<WithCount<int[]>> patternFrequencies;
    private List<int[]> rightmostPaths;
    private final GSpanLogic gSpan;
    private final boolean compressGraphs;
    private final boolean compressPatterns;
    private final boolean uncompressFrequentPatterns;
    private final boolean compressEmbeddings;
    private final boolean validatePatterns;

    public GrowFrequentPatterns(GSpanLogic gSpan, DIMSpanConfig fsmConfig) {
        this.gSpan = gSpan;
        this.compressGraphs = fsmConfig.isGraphCompressionEnabled();
        this.compressEmbeddings = fsmConfig.isEmbeddingCompressionEnabled();
        this.compressPatterns = fsmConfig.getPatternCompressionInStep() == DataflowStep.MAP;
        this.uncompressFrequentPatterns = fsmConfig.getPatternCompressionInStep() != DataflowStep.WITHOUT;
        this.validatePatterns = fsmConfig.getPatternVerificationInStep() == DataflowStep.MAP;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.patternFrequencies = this.getRuntimeContext().getBroadcastVariable("fp");
        int patternCount = this.patternFrequencies.size();
        this.frequentPatterns = Lists.newArrayListWithExpectedSize((int)patternCount);
        for (WithCount<int[]> patternWithCount : this.patternFrequencies) {
            int[] pattern = patternWithCount.getObject();
            if (this.uncompressFrequentPatterns) {
                pattern = Simple16Compressor.uncompress(pattern);
            }
            this.frequentPatterns.add(pattern);
        }
        this.frequentPatterns.sort(new DFSCodeComparator());
        this.rightmostPaths = Lists.newArrayListWithExpectedSize((int)patternCount);
        this.compressedFrequentPatterns = Lists.newArrayListWithExpectedSize((int)patternCount);
        for (int[] pattern : this.frequentPatterns) {
            this.rightmostPaths.add(this.gSpan.getRightmostPathTimes(pattern));
            this.compressedFrequentPatterns.add(this.compressPatterns ? Simple16Compressor.compress(pattern) : pattern);
        }
    }

    public GraphWithPatternEmbeddingsMap map(GraphWithPatternEmbeddingsMap pair) throws Exception {
        if (pair.isFrequentPatternCollector()) {
            for (WithCount<int[]> patternWithFrequency : this.patternFrequencies) {
                pair.getMap().collect(patternWithFrequency);
            }
        } else {
            int[] graph = pair.getGraph();
            if (this.compressGraphs) {
                graph = Simple16Compressor.uncompress(graph);
            }
            PatternEmbeddingsMap childMap = this.gSpan.growPatterns(graph, pair.getMap(), this.frequentPatterns, this.rightmostPaths, this.compressEmbeddings, this.compressedFrequentPatterns);
            if (this.validatePatterns) {
                PatternEmbeddingsMap validatedMap = PatternEmbeddingsMap.getEmptyOne();
                for (int i = 0; i < childMap.getPatternCount(); ++i) {
                    int[] pattern = childMap.getPattern(i);
                    if (!this.gSpan.isMinimal(pattern)) continue;
                    int[] embeddingData = childMap.getValues()[i];
                    validatedMap.put(pattern, embeddingData);
                }
                childMap = validatedMap;
            }
            pair.setPatternEmbeddings(childMap);
            if (this.compressPatterns) {
                Simple16Compressor.compressPatterns(pair.getMap());
            }
            if (this.compressEmbeddings) {
                Simple16Compressor.compressEmbeddings(pair.getMap());
            }
        }
        return pair;
    }
}

