/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.functions.mining;

import org.apache.flink.api.common.functions.MapFunction;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DIMSpanConfig;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DataflowStep;
import org.gradoop.flink.algorithms.fsm.dimspan.gspan.GSpanLogic;
import org.gradoop.flink.algorithms.fsm.dimspan.model.Simple16Compressor;
import org.gradoop.flink.algorithms.fsm.dimspan.tuples.GraphWithPatternEmbeddingsMap;
import org.gradoop.flink.algorithms.fsm.dimspan.tuples.PatternEmbeddingsMap;

public class InitSingleEdgePatternEmbeddingsMap
implements MapFunction<int[], GraphWithPatternEmbeddingsMap> {
    private final GSpanLogic gSpan;
    private final boolean compressGraphs;
    private final boolean compressPatterns;
    private final boolean compressEmbeddings;

    public InitSingleEdgePatternEmbeddingsMap(GSpanLogic gSpan, DIMSpanConfig fsmConfig) {
        this.gSpan = gSpan;
        this.compressGraphs = fsmConfig.isGraphCompressionEnabled();
        this.compressEmbeddings = fsmConfig.isEmbeddingCompressionEnabled();
        this.compressPatterns = fsmConfig.getPatternCompressionInStep() == DataflowStep.MAP;
    }

    public GraphWithPatternEmbeddingsMap map(int[] graph) throws Exception {
        PatternEmbeddingsMap map = this.gSpan.getSingleEdgePatternEmbeddings(graph);
        if (this.compressGraphs) {
            graph = Simple16Compressor.compress(graph);
        }
        if (this.compressPatterns) {
            Simple16Compressor.compressPatterns(map);
        }
        if (this.compressEmbeddings) {
            Simple16Compressor.compressEmbeddings(map);
        }
        return new GraphWithPatternEmbeddingsMap(graph, map);
    }
}

