/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.functions.mining;

import org.apache.flink.api.common.functions.FilterFunction;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DIMSpanConfig;
import org.gradoop.flink.algorithms.fsm.dimspan.gspan.GSpanLogic;
import org.gradoop.flink.algorithms.fsm.dimspan.model.GraphUtils;
import org.gradoop.flink.algorithms.fsm.dimspan.model.GraphUtilsBase;
import org.gradoop.flink.algorithms.fsm.dimspan.model.Simple16Compressor;
import org.gradoop.flink.model.impl.tuples.WithCount;

public class VerifyPattern
implements FilterFunction<WithCount<int[]>> {
    private final GSpanLogic gSpan;
    private final boolean uncompress;
    private GraphUtils graphUtils = new GraphUtilsBase();

    public VerifyPattern(GSpanLogic gSpan, DIMSpanConfig fsmConfig) {
        this.gSpan = gSpan;
        this.uncompress = fsmConfig.getPatternCompressionInStep().compareTo(fsmConfig.getPatternVerificationInStep()) < 0;
    }

    public boolean filter(WithCount<int[]> traversalCodeWithCount) throws Exception {
        int[] pattern = traversalCodeWithCount.getObject();
        boolean valid = true;
        if (this.uncompress) {
            pattern = Simple16Compressor.uncompress(pattern);
        }
        if (this.graphUtils.getEdgeCount(pattern) > 1) {
            valid = this.gSpan.isMinimal(pattern);
        }
        return valid;
    }
}

