/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.functions.preprocessing;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.java.aggregation.AggregationFunction;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.gradoop.flink.model.impl.tuples.WithCount;

public class AggregateMultipleFunctions
extends RichGroupReduceFunction<WithCount<int[]>, WithCount<int[]>>
implements GroupCombineFunction<WithCount<int[]>, WithCount<int[]>> {
    private int[] field;
    private final AggregationFunction<Long>[] aggregationFunctions;

    public AggregateMultipleFunctions(AggregationFunction<Long>[] aggregationFunctions, int[] field) {
        Preconditions.checkArgument((aggregationFunctions.length == field.length ? 1 : 0) != 0);
        Preconditions.checkArgument((aggregationFunctions.length > 0 ? 1 : 0) != 0);
        this.field = Arrays.copyOf(field, field.length);
        this.aggregationFunctions = Arrays.copyOf(aggregationFunctions, aggregationFunctions.length);
    }

    public void combine(Iterable<WithCount<int[]>> iterable, Collector<WithCount<int[]>> collector) throws Exception {
        this.reduce(iterable, collector);
    }

    public void reduce(Iterable<WithCount<int[]>> iterable, Collector<WithCount<int[]>> collector) throws Exception {
        WithCount<int[]> result = null;
        Iterator<WithCount<int[]>> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            WithCount<int[]> tuple;
            result = tuple = iterator.next();
            for (int i = 0; i < this.field.length; ++i) {
                Long value = (Long)tuple.getField(this.field[i]);
                this.aggregationFunctions[i].aggregate((Object)value);
            }
        }
        for (int i = 0; i < this.field.length; ++i) {
            Long aggregatedValue = (Long)this.aggregationFunctions[i].getAggregate();
            result.setField(aggregatedValue, this.field[i]);
            this.aggregationFunctions[i].initializeAggregate();
        }
        collector.collect(result);
    }
}

