/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.functions.preprocessing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.util.Collector;
import org.gradoop.flink.algorithms.fsm.dimspan.comparison.LabelComparator;
import org.gradoop.flink.model.impl.tuples.WithCount;

public class CreateDictionary
implements GroupReduceFunction<WithCount<String>, String[]> {
    private final LabelComparator comparator;

    public CreateDictionary(LabelComparator comparator) {
        this.comparator = comparator;
    }

    public void reduce(Iterable<WithCount<String>> iterable, Collector<String[]> collector) throws Exception {
        ArrayList stringsWithCount = Lists.newArrayList(iterable);
        stringsWithCount.sort(this.comparator);
        ArrayList dictionary = Lists.newArrayList();
        for (WithCount stringWithCount : stringsWithCount) {
            dictionary.add(stringWithCount.getObject());
        }
        collector.collect((Object)dictionary.toArray(new String[dictionary.size()]));
    }
}

