/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.functions.preprocessing;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.flink.algorithms.fsm.dimspan.comparison.DFSBranchComparator;
import org.gradoop.flink.algorithms.fsm.dimspan.comparison.DirectedDFSBranchComparator;
import org.gradoop.flink.algorithms.fsm.dimspan.comparison.UndirectedDFSBranchComparator;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DIMSpanConfig;
import org.gradoop.flink.algorithms.fsm.dimspan.model.SearchGraphUtils;
import org.gradoop.flink.algorithms.fsm.dimspan.model.UnsortedSearchGraphUtils;
import org.gradoop.flink.algorithms.fsm.dimspan.tuples.LabeledGraphIntString;

public class EncodeAndPruneEdges
extends RichMapFunction<LabeledGraphIntString, int[]> {
    private Map<String, Integer> edgeDictionary = Maps.newHashMap();
    private final boolean sortGraph;
    private final DFSBranchComparator branchComparator;
    private final SearchGraphUtils graphUtils = new UnsortedSearchGraphUtils();

    public EncodeAndPruneEdges(DIMSpanConfig fsmConfig) {
        this.sortGraph = fsmConfig.isBranchConstraintEnabled();
        this.branchComparator = fsmConfig.isDirected() ? new DirectedDFSBranchComparator() : new UndirectedDFSBranchComparator();
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        String[] broadcast = (String[])this.getRuntimeContext().getBroadcastVariable("eld").get(0);
        for (int i = 0; i < broadcast.length; ++i) {
            this.edgeDictionary.put(broadcast[i], i);
        }
    }

    public int[] map(LabeledGraphIntString inGraph) throws Exception {
        Object dfsCodes = new int[][]{};
        for (int edgeId = 0; edgeId < inGraph.size(); ++edgeId) {
            Integer edgeLabel = this.edgeDictionary.get(inGraph.getEdgeLabel(edgeId));
            if (edgeLabel == null) continue;
            int sourceId = inGraph.getSourceId(edgeId);
            int sourceLabel = inGraph.getSourceLabel(edgeId);
            int targetId = inGraph.getTargetId(edgeId);
            int targetLabel = inGraph.getTargetLabel(edgeId);
            int[] dfsCode = sourceLabel <= targetLabel ? this.graphUtils.multiplex(sourceId, sourceLabel, true, edgeLabel, targetId, targetLabel) : this.graphUtils.multiplex(targetId, targetLabel, false, edgeLabel, sourceId, sourceLabel);
            dfsCodes = (int[][])ArrayUtils.add((Object[])dfsCodes, (Object)dfsCode);
        }
        if (this.sortGraph) {
            Arrays.sort(dfsCodes, this.branchComparator);
        }
        int[] outGraph = new int[((int[][])dfsCodes).length * 6];
        int i = 0;
        for (int[] dfsCode : dfsCodes) {
            System.arraycopy(dfsCode, 0, outGraph, i * 6, 6);
            ++i;
        }
        return outGraph;
    }
}

