/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.functions.preprocessing;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.flink.algorithms.fsm.dimspan.tuples.LabeledGraphIntString;
import org.gradoop.flink.algorithms.fsm.dimspan.tuples.LabeledGraphStringString;

public class EncodeAndPruneVertices
extends RichMapFunction<LabeledGraphStringString, LabeledGraphIntString> {
    private Map<String, Integer> vertexDictionary = Maps.newHashMap();
    private final Map<Integer, Integer> vertexIdMap = Maps.newHashMap();

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        String[] broadcast = (String[])this.getRuntimeContext().getBroadcastVariable("vld").get(0);
        for (int i = 0; i < broadcast.length; ++i) {
            this.vertexDictionary.put(broadcast[i], i);
        }
    }

    public LabeledGraphIntString map(LabeledGraphStringString inGraph) throws Exception {
        LabeledGraphIntString outGraph = LabeledGraphIntString.getEmptyOne();
        this.vertexIdMap.clear();
        String[] oldVertexLabels = inGraph.getVertexLabels();
        int[] newVertexLabels = new int[]{};
        for (int oldId = 0; oldId < oldVertexLabels.length; ++oldId) {
            Integer label = this.vertexDictionary.get(oldVertexLabels[oldId]);
            if (label == null) continue;
            this.vertexIdMap.put(oldId, newVertexLabels.length);
            newVertexLabels = ArrayUtils.add((int[])newVertexLabels, (int)label);
        }
        for (int edgeId = 0; edgeId < inGraph.getEdgeLabels().length; ++edgeId) {
            Integer targetId;
            Integer sourceId = this.vertexIdMap.get(inGraph.getSourceId(edgeId));
            if (sourceId == null || (targetId = this.vertexIdMap.get(inGraph.getTargetId(edgeId))) == null) continue;
            int sourceLabel = newVertexLabels[sourceId];
            int targetLabel = newVertexLabels[targetId];
            outGraph.addEdge(sourceId, sourceLabel, inGraph.getEdgeLabel(edgeId), targetId, targetLabel);
        }
        return outGraph;
    }
}

