/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.gspan;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.gradoop.flink.algorithms.fsm.dimspan.comparison.DFSCodeComparator;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DIMSpanConfig;
import org.gradoop.flink.algorithms.fsm.dimspan.gspan.GSpanLogic;
import org.gradoop.flink.algorithms.fsm.dimspan.model.DFSCodeUtils;
import org.gradoop.flink.algorithms.fsm.dimspan.model.SearchGraphUtils;
import org.gradoop.flink.algorithms.fsm.dimspan.model.SortedSearchGraphUtils;
import org.gradoop.flink.algorithms.fsm.dimspan.model.UnsortedSearchGraphUtils;
import org.gradoop.flink.algorithms.fsm.dimspan.tuples.PatternEmbeddingsMap;

public abstract class GSpanLogicBase
implements GSpanLogic,
Serializable {
    private final DFSCodeComparator comparator = new DFSCodeComparator();
    private final SearchGraphUtils graphUtils;
    private final boolean branchConstraintEnabled;
    private final DFSCodeUtils dfsCodeUtils = new DFSCodeUtils();

    protected GSpanLogicBase(DIMSpanConfig fsmConfig) {
        this.branchConstraintEnabled = fsmConfig.isBranchConstraintEnabled();
        this.graphUtils = this.branchConstraintEnabled ? new SortedSearchGraphUtils(fsmConfig) : new UnsortedSearchGraphUtils();
    }

    @Override
    public PatternEmbeddingsMap getSingleEdgePatternEmbeddings(int[] graph) {
        PatternEmbeddingsMap patternEmbeddings = PatternEmbeddingsMap.getEmptyOne();
        for (int edgeId = 0; edgeId < this.graphUtils.getEdgeCount(graph); ++edgeId) {
            int[] nArray;
            boolean loop;
            int fromId = this.graphUtils.getFromId(graph, edgeId);
            int fromLabel = this.graphUtils.getFromLabel(graph, edgeId);
            int toId = this.graphUtils.getToId(graph, edgeId);
            int toLabel = this.graphUtils.getToLabel(graph, edgeId);
            boolean bl = loop = fromId == toId;
            if (loop) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = fromId;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = fromId;
                nArray = nArray3;
                nArray3[1] = toId;
            }
            int[] vertexIds = nArray;
            int[] edgeIds = new int[]{edgeId};
            int edgeLabel = this.graphUtils.getEdgeLabel(graph, edgeId);
            int fromTime = 0;
            int toTime = loop ? 0 : 1;
            boolean outgoing = this.getSingleEdgePatternIsOutgoing(graph, edgeId, loop);
            int[] pattern = this.graphUtils.multiplex(fromTime, fromLabel, outgoing, edgeLabel, toTime, toLabel);
            this.storeSingleEdgePatternEmbeddings(patternEmbeddings, pattern, vertexIds, edgeIds, fromLabel, toLabel, loop);
        }
        return patternEmbeddings;
    }

    protected abstract void storeSingleEdgePatternEmbeddings(PatternEmbeddingsMap var1, int[] var2, int[] var3, int[] var4, int var5, int var6, boolean var7);

    protected abstract boolean getSingleEdgePatternIsOutgoing(int[] var1, int var2, boolean var3);

    @Override
    public int[] getRightmostPathTimes(int[] pattern) {
        int[] rightmostPathTimes;
        if (this.graphUtils.getEdgeCount(pattern) == 1) {
            rightmostPathTimes = this.graphUtils.getFromId(pattern, 0) == this.graphUtils.getToId(pattern, 0) ? new int[]{0} : new int[]{1, 0};
        } else {
            rightmostPathTimes = new int[]{};
            for (int edgeTime = this.graphUtils.getEdgeCount(pattern) - 1; edgeTime >= 0; --edgeTime) {
                boolean firstStep;
                int fromTime = this.graphUtils.getFromId(pattern, edgeTime);
                int toTime = this.graphUtils.getToId(pattern, edgeTime);
                boolean bl = firstStep = rightmostPathTimes.length == 0;
                if (toTime > fromTime) {
                    if (firstStep) {
                        rightmostPathTimes = ArrayUtils.add((int[])rightmostPathTimes, (int)toTime);
                        rightmostPathTimes = ArrayUtils.add((int[])rightmostPathTimes, (int)fromTime);
                        continue;
                    }
                    if (ArrayUtils.indexOf((int[])rightmostPathTimes, (int)toTime) < 0) continue;
                    rightmostPathTimes = ArrayUtils.add((int[])rightmostPathTimes, (int)fromTime);
                    continue;
                }
                if (!firstStep || fromTime != toTime) continue;
                rightmostPathTimes = ArrayUtils.add((int[])rightmostPathTimes, (int)0);
            }
        }
        return rightmostPathTimes;
    }

    @Override
    public PatternEmbeddingsMap growPatterns(int[] graph, PatternEmbeddingsMap parentMap, List<int[]> frequentPatterns, List<int[]> rightmostPaths, boolean uncompressEmbeddings, List<int[]> compressedPatterns) {
        PatternEmbeddingsMap childMap = PatternEmbeddingsMap.getEmptyOne();
        int minEdgeId = 0;
        int[] minExtension = new int[]{0, 0, 0, 0, 0, 0};
        for (int frequentPatternIndex = 0; frequentPatternIndex < frequentPatterns.size(); ++frequentPatternIndex) {
            int[] firstExtension;
            int[] compressedPattern = compressedPatterns.get(frequentPatternIndex);
            int parentPatternIndex = parentMap.getIndex(compressedPattern);
            if (parentPatternIndex < 0) continue;
            int[] parentPattern = frequentPatterns.get(frequentPatternIndex);
            if (this.branchConstraintEnabled && !Objects.deepEquals(minExtension, firstExtension = this.dfsCodeUtils.getBranch(parentPattern))) {
                if ((minEdgeId = this.graphUtils.getFirstGeqEdgeId(graph, firstExtension, minEdgeId)) < 0) break;
                minExtension = firstExtension;
            }
            int[] rightmostPath = rightmostPaths.get(frequentPatternIndex);
            int[][] parentEmbeddings = parentMap.getEmbeddings(parentPatternIndex, uncompressEmbeddings);
            PatternEmbeddingsMap currentParentMap = this.growPattern(graph, minEdgeId, parentPattern, parentEmbeddings, rightmostPath);
            childMap.append(currentParentMap);
        }
        return childMap;
    }

    private PatternEmbeddingsMap growPattern(int[] graph, int minEdgeId, int[] parentPattern, int[][] parentEmbeddings, int[] rightmostPath) {
        PatternEmbeddingsMap currentChildMap = PatternEmbeddingsMap.getEmptyOne();
        for (int m = 0; m < parentEmbeddings.length / 2; ++m) {
            int[] parentVertexIds = parentEmbeddings[2 * m];
            int[] parentEdgeIds = parentEmbeddings[2 * m + 1];
            int forwardsTime = this.graphUtils.getVertexCount(parentPattern);
            int rightmostTime = rightmostPath[0];
            block1: for (int edgeId = minEdgeId; edgeId < this.graphUtils.getEdgeCount(graph); ++edgeId) {
                int[] childPattern;
                if (ArrayUtils.contains((int[])parentEdgeIds, (int)edgeId)) continue;
                int edgeFromId = this.graphUtils.getFromId(graph, edgeId);
                int fromTime = ArrayUtils.indexOf((int[])parentVertexIds, (int)edgeFromId);
                int edgeToId = this.graphUtils.getToId(graph, edgeId);
                int toTime = ArrayUtils.indexOf((int[])parentVertexIds, (int)edgeToId);
                if (fromTime == rightmostTime && toTime >= 0) {
                    childPattern = this.dfsCodeUtils.addExtension(parentPattern, fromTime, this.graphUtils.getFromLabel(graph, edgeId), this.getExtensionIsOutgoing(graph, edgeId, true), this.graphUtils.getEdgeLabel(graph, edgeId), toTime, this.graphUtils.getToLabel(graph, edgeId));
                    int[] childVertexIds = (int[])parentVertexIds.clone();
                    int[] childEdgeIds = ArrayUtils.add((int[])parentEdgeIds, (int)edgeId);
                    currentChildMap.put(childPattern, childVertexIds, childEdgeIds);
                    continue;
                }
                if (toTime == rightmostTime && fromTime >= 0) {
                    childPattern = this.dfsCodeUtils.addExtension(parentPattern, toTime, this.graphUtils.getToLabel(graph, edgeId), this.getExtensionIsOutgoing(graph, edgeId, false), this.graphUtils.getEdgeLabel(graph, edgeId), fromTime, this.graphUtils.getFromLabel(graph, edgeId));
                    int[] childVertexIds = (int[])parentVertexIds.clone();
                    int[] childEdgeIds = ArrayUtils.add((int[])parentEdgeIds, (int)edgeId);
                    currentChildMap.put(childPattern, childVertexIds, childEdgeIds);
                    continue;
                }
                for (int rightmostPathTime : rightmostPath) {
                    int[] childEdgeIds;
                    int[] childVertexIds;
                    int[] childPattern2;
                    if (fromTime == rightmostPathTime && toTime < 0) {
                        childPattern2 = this.dfsCodeUtils.addExtension(parentPattern, fromTime, this.graphUtils.getFromLabel(graph, edgeId), this.getExtensionIsOutgoing(graph, edgeId, true), this.graphUtils.getEdgeLabel(graph, edgeId), forwardsTime, this.graphUtils.getToLabel(graph, edgeId));
                        childVertexIds = ArrayUtils.add((int[])parentVertexIds, (int)edgeToId);
                        childEdgeIds = ArrayUtils.add((int[])parentEdgeIds, (int)edgeId);
                        currentChildMap.put(childPattern2, childVertexIds, childEdgeIds);
                        continue block1;
                    }
                    if (toTime != rightmostPathTime || fromTime >= 0) continue;
                    childPattern2 = this.dfsCodeUtils.addExtension(parentPattern, toTime, this.graphUtils.getToLabel(graph, edgeId), this.getExtensionIsOutgoing(graph, edgeId, false), this.graphUtils.getEdgeLabel(graph, edgeId), forwardsTime, this.graphUtils.getFromLabel(graph, edgeId));
                    childVertexIds = ArrayUtils.add((int[])parentVertexIds, (int)edgeFromId);
                    childEdgeIds = ArrayUtils.add((int[])parentEdgeIds, (int)edgeId);
                    currentChildMap.put(childPattern2, childVertexIds, childEdgeIds);
                    continue block1;
                }
            }
        }
        return currentChildMap;
    }

    protected abstract boolean getExtensionIsOutgoing(int[] var1, int var2, boolean var3);

    @Override
    public boolean isMinimal(int[] pattern) {
        boolean minimal = true;
        int[] graph = this.getGraph(pattern);
        PatternEmbeddingsMap subEmbeddingsMap = this.getSingleEdgePatternEmbeddings(graph);
        for (int k = 0; k < this.graphUtils.getEdgeCount(graph); ++k) {
            int minPatternIndex = 0;
            int[] minPattern = subEmbeddingsMap.getPattern(minPatternIndex);
            for (int patIndex = 1; patIndex < subEmbeddingsMap.getPatternCount(); ++patIndex) {
                int[] subPattern = subEmbeddingsMap.getPattern(patIndex);
                if (this.comparator.compare(subPattern, minPattern) >= 0) continue;
                minPattern = subPattern;
                minPatternIndex = patIndex;
            }
            minimal = this.dfsCodeUtils.isChildOf(minPattern, pattern);
            if (!minimal) break;
            subEmbeddingsMap = this.growPattern(graph, 0, minPattern, subEmbeddingsMap.getEmbeddings(minPatternIndex, false), this.getRightmostPathTimes(minPattern));
        }
        return minimal;
    }

    @Override
    public int[] getGraph(int[] pattern) {
        int[] graph = new int[]{};
        for (int edgeTime = 0; edgeTime < this.graphUtils.getEdgeCount(pattern); ++edgeTime) {
            int targetLabel;
            int targetId;
            int sourceLabel;
            int sourceId;
            int edgeLabel = this.graphUtils.getEdgeLabel(pattern, edgeTime);
            if (this.graphUtils.isOutgoing(pattern, edgeTime)) {
                sourceId = this.graphUtils.getFromId(pattern, edgeTime);
                sourceLabel = this.graphUtils.getFromLabel(pattern, edgeTime);
                targetId = this.graphUtils.getToId(pattern, edgeTime);
                targetLabel = this.graphUtils.getToLabel(pattern, edgeTime);
            } else {
                sourceId = this.graphUtils.getToId(pattern, edgeTime);
                sourceLabel = this.graphUtils.getToLabel(pattern, edgeTime);
                targetId = this.graphUtils.getFromId(pattern, edgeTime);
                targetLabel = this.graphUtils.getFromLabel(pattern, edgeTime);
            }
            graph = this.graphUtils.addEdge(graph, sourceId, sourceLabel, edgeLabel, targetId, targetLabel);
        }
        return graph;
    }
}

