/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.model;

import org.gradoop.flink.algorithms.fsm.dimspan.model.GraphUtils;

public class GraphUtilsBase
implements GraphUtils {
    @Override
    public int[] multiplex(int fromId, int fromLabel, boolean outgoing, int edgeLabel, int toId, int toLabel) {
        int[] edge = new int[6];
        edge[4] = fromId;
        edge[5] = toId;
        edge[1] = outgoing ? 0 : 1;
        edge[2] = edgeLabel;
        edge[0] = fromLabel;
        edge[3] = toLabel;
        return edge;
    }

    @Override
    public int getVertexCount(int[] mux) {
        int maxId = 0;
        for (int edgeId = 0; edgeId < this.getEdgeCount(mux); ++edgeId) {
            maxId = Math.max(maxId, Math.max(this.getFromId(mux, edgeId), this.getToId(mux, edgeId)));
        }
        return maxId + 1;
    }

    @Override
    public int getEdgeCount(int[] mux) {
        return mux.length / 6;
    }

    @Override
    public int[] getVertexLabels(int[] mux) {
        int[] vertexLabels = new int[this.getVertexCount(mux)];
        for (int edgeId = 0; edgeId < this.getEdgeCount(mux); ++edgeId) {
            vertexLabels[this.getFromId((int[])mux, (int)edgeId)] = this.getFromLabel(mux, edgeId);
            vertexLabels[this.getToId((int[])mux, (int)edgeId)] = this.getToLabel(mux, edgeId);
        }
        return vertexLabels;
    }

    @Override
    public int getFromId(int[] mux, int id) {
        return mux[id * 6 + 4];
    }

    @Override
    public int getToId(int[] mux, int id) {
        return mux[id * 6 + 5];
    }

    @Override
    public int getFromLabel(int[] mux, int id) {
        return mux[id * 6 + 0];
    }

    @Override
    public int getEdgeLabel(int[] mux, int id) {
        return mux[id * 6 + 2];
    }

    @Override
    public boolean isOutgoing(int[] mux, int edgeId) {
        return mux[edgeId * 6 + 1] == 0;
    }

    @Override
    public int getToLabel(int[] mux, int id) {
        return mux[id * 6 + 3];
    }

    @Override
    public boolean isLoop(int[] mux, int edgeId) {
        return this.getFromId(mux, edgeId) == this.getToId(mux, edgeId);
    }
}

