/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.model;

import org.gradoop.flink.algorithms.fsm.dimspan.comparison.DFSBranchComparator;
import org.gradoop.flink.algorithms.fsm.dimspan.comparison.DirectedDFSBranchComparator;
import org.gradoop.flink.algorithms.fsm.dimspan.comparison.UndirectedDFSBranchComparator;
import org.gradoop.flink.algorithms.fsm.dimspan.config.DIMSpanConfig;
import org.gradoop.flink.algorithms.fsm.dimspan.model.SearchGraphUtilsBase;

public class SortedSearchGraphUtils
extends SearchGraphUtilsBase {
    private final DFSBranchComparator comparator;

    public SortedSearchGraphUtils(DIMSpanConfig fsmConfig) {
        this.comparator = fsmConfig.isDirected() ? new DirectedDFSBranchComparator() : new UndirectedDFSBranchComparator();
    }

    @Override
    public int getFirstGeqEdgeId(int[] graphMux, int[] searchMux, int searchFromEdgeId) {
        int firstGeqEdgeId = -1;
        for (int edgeId = searchFromEdgeId; edgeId < this.getEdgeCount(graphMux); ++edgeId) {
            if (this.comparator.compare(searchMux, this.getEdge(graphMux, edgeId)) < 0) continue;
            firstGeqEdgeId = edgeId;
            break;
        }
        return firstGeqEdgeId;
    }

    private int[] getEdge(int[] graphMux, int edgeId) {
        int[] edgeMux = new int[6];
        edgeMux[4] = this.getFromId(graphMux, edgeId);
        edgeMux[5] = this.getToId(graphMux, edgeId);
        edgeMux[0] = this.getFromLabel(graphMux, edgeId);
        edgeMux[3] = this.getToLabel(graphMux, edgeId);
        edgeMux[1] = this.isOutgoing(graphMux, edgeId) ? 0 : 1;
        edgeMux[2] = this.getEdgeLabel(graphMux, edgeId);
        return edgeMux;
    }
}

