/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.dimspan.tuples;

import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.gradoop.flink.algorithms.fsm.dimspan.model.Simple16Compressor;
import org.gradoop.flink.model.impl.tuples.WithCount;

public class PatternEmbeddingsMap
extends Tuple2<int[][], int[][]> {
    public PatternEmbeddingsMap() {
    }

    public PatternEmbeddingsMap(int[][] patternMuxes, int[][] embeddingMuxes) {
        super((Object)patternMuxes, (Object)embeddingMuxes);
    }

    public int getPatternCount() {
        return this.getKeys().length;
    }

    public boolean isEmpty() {
        return this.getPatternCount() == 0;
    }

    public int[] getPattern(int index) {
        return this.getKeys()[index];
    }

    public int getIndex(int[] patternMux) {
        int index = -1;
        int i = 0;
        for (int[] mux : this.getKeys()) {
            if (Objects.deepEquals(mux, patternMux)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public void put(int[] patternMux, int[] vertexIds, int[] edgeIds) {
        int patternIndex = this.getIndex(patternMux);
        int[] vertexEdgeIds = ArrayUtils.addAll((int[])vertexIds, (int[])edgeIds);
        if (patternIndex < 0) {
            this.setKeys((int[][])ArrayUtils.add((Object[])this.getKeys(), (Object)patternMux));
            int[] embeddingData = new int[]{vertexIds.length, edgeIds.length};
            embeddingData = ArrayUtils.addAll((int[])embeddingData, (int[])vertexEdgeIds);
            this.setValues((int[][])ArrayUtils.add((Object[])this.getValues(), (Object)embeddingData));
        } else {
            this.getValues()[patternIndex] = ArrayUtils.addAll((int[])this.getValues()[patternIndex], (int[])vertexEdgeIds);
        }
    }

    public void put(int[] patternMux, int[] embeddingsMux) {
        this.setKeys((int[][])ArrayUtils.add((Object[])this.getKeys(), (Object)patternMux));
        this.setValues((int[][])ArrayUtils.add((Object[])this.getValues(), (Object)embeddingsMux));
    }

    public void append(PatternEmbeddingsMap that) {
        this.setKeys((int[][])ArrayUtils.addAll((Object[])this.getKeys(), (Object[])that.getKeys()));
        this.setValues((int[][])ArrayUtils.addAll((Object[])this.getValues(), (Object[])that.getValues()));
    }

    public void collect(WithCount<int[]> muxWithCount) {
        this.setKeys((int[][])ArrayUtils.add((Object[])this.getKeys(), (Object)muxWithCount.getObject()));
        this.setValues((int[][])ArrayUtils.add((Object[])this.getValues(), (Object)new int[]{(int)muxWithCount.getCount()}));
    }

    public int[][] getEmbeddings(int index, boolean uncompress) {
        int[] embeddingData = this.getValues()[index];
        if (uncompress) {
            embeddingData = Simple16Compressor.uncompress(embeddingData);
        }
        int vertexCount = embeddingData[0];
        int edgeCount = embeddingData[1];
        int embeddingLength = vertexCount + edgeCount;
        int embeddingCount = (embeddingData.length - 2) / embeddingLength;
        int[][] embeddings = new int[2 * embeddingCount][];
        int i = 2;
        for (int m = 0; m < embeddingCount; ++m) {
            int[] vertexIds = new int[vertexCount];
            for (int v = 0; v < vertexCount; ++v) {
                vertexIds[v] = embeddingData[i];
                ++i;
            }
            embeddings[2 * m] = vertexIds;
            int[] edgeIds = new int[edgeCount];
            for (int e = 0; e < edgeCount; ++e) {
                edgeIds[e] = embeddingData[i];
                ++i;
            }
            embeddings[2 * m + 1] = edgeIds;
        }
        return embeddings;
    }

    public int[][] getKeys() {
        return (int[][])this.f0;
    }

    public int[][] getValues() {
        return (int[][])this.f1;
    }

    private void setKeys(int[][] patternMuxes) {
        this.f0 = patternMuxes;
    }

    private void setValues(int[][] embeddingMuxes) {
        this.f1 = embeddingMuxes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.getPatternCount(); ++i) {
            builder.append(new Tuple1((Object)this.getPattern(i)));
            builder.append("\t");
            builder.append(new Tuple1((Object)this.getValues()[i]));
            builder.append("\n");
        }
        return builder.toString();
    }

    public static PatternEmbeddingsMap getEmptyOne() {
        return new PatternEmbeddingsMap(new int[0][], new int[0][]);
    }
}

