/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.UnionOperator;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.mining.Frequent;
import org.gradoop.flink.algorithms.fsm.transactional.common.FSMConfig;
import org.gradoop.flink.algorithms.fsm.transactional.tle.ThinkLikeAnEmbeddingFSMBase;
import org.gradoop.flink.algorithms.fsm.transactional.tle.functions.IsResult;
import org.gradoop.flink.algorithms.fsm.transactional.tle.functions.MinEdgeCount;
import org.gradoop.flink.algorithms.fsm.transactional.tle.functions.TFSMSingleEdgeEmbeddings;
import org.gradoop.flink.algorithms.fsm.transactional.tle.functions.TFSMSubgraphDecoder;
import org.gradoop.flink.algorithms.fsm.transactional.tle.functions.TFSMSubgraphOnly;
import org.gradoop.flink.algorithms.fsm.transactional.tle.functions.TFSMWrapInSubgraphEmbeddings;
import org.gradoop.flink.algorithms.fsm.transactional.tle.functions.ToTFSMGraph;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.TFSMGraph;
import org.gradoop.flink.algorithms.fsm.transactional.tle.tuples.TFSMSubgraph;
import org.gradoop.flink.algorithms.fsm.transactional.tle.tuples.TFSMSubgraphEmbeddings;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class ThinkLikeAnEmbeddingTFSM
extends ThinkLikeAnEmbeddingFSMBase<TFSMGraph, TFSMSubgraph, TFSMSubgraphEmbeddings> {
    public ThinkLikeAnEmbeddingTFSM(FSMConfig fsmConfig) {
        super(fsmConfig);
    }

    @Override
    public DataSet<GraphTransaction> execute(DataSet<GraphTransaction> transactions) {
        transactions = this.preProcess(transactions);
        MapOperator graphs = transactions.map((MapFunction)new ToTFSMGraph());
        FlatMapOperator embeddings = graphs.flatMap((FlatMapFunction)new TFSMSingleEdgeEmbeddings(this.fsmConfig));
        IterativeDataSet iterative = embeddings.iterate(this.fsmConfig.getMaxEdgeCount());
        DataSet parentEmbeddings = iterative.filter(new IsResult(false));
        DataSet<TFSMSubgraph> frequentSubgraphs = this.getFrequentSubgraphs((DataSet<TFSMSubgraphEmbeddings>)parentEmbeddings);
        parentEmbeddings = this.filterByFrequentSubgraphs(parentEmbeddings, frequentSubgraphs);
        DataSet childEmbeddings = this.growEmbeddingsOfFrequentSubgraphs(parentEmbeddings, frequentSubgraphs);
        MapOperator resultIncrement = frequentSubgraphs.map((MapFunction)new TFSMWrapInSubgraphEmbeddings());
        UnionOperator resultAndEmbeddings = iterative.filter(new IsResult(true)).union((DataSet)resultIncrement).union(childEmbeddings);
        MapOperator allFrequentSubgraphs = iterative.closeWith((DataSet)resultAndEmbeddings, childEmbeddings).filter(new IsResult(true)).map((MapFunction)new TFSMSubgraphOnly());
        if (this.fsmConfig.getMinEdgeCount() > 1) {
            allFrequentSubgraphs = allFrequentSubgraphs.filter(new MinEdgeCount(this.fsmConfig));
        }
        return allFrequentSubgraphs.map((MapFunction)new TFSMSubgraphDecoder(this.config));
    }

    private DataSet<TFSMSubgraph> getFrequentSubgraphs(DataSet<TFSMSubgraphEmbeddings> embeddings) {
        return embeddings.map((MapFunction)new TFSMSubgraphOnly()).groupBy(new int[]{0}).sum(1).filter(new Frequent()).withBroadcastSet(this.minFrequency, "fmin");
    }
}

