/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.common.functions;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class FilterEdgesByLabel
extends RichMapFunction<GraphTransaction, GraphTransaction> {
    private Collection<String> frequentEdgeLabels;

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        List broadcast = this.getRuntimeContext().getBroadcastVariable("fel");
        this.frequentEdgeLabels = Sets.newHashSet((Iterable)broadcast);
    }

    public GraphTransaction map(GraphTransaction transaction) throws Exception {
        HashSet referenceEdgeIds = Sets.newHashSet();
        Iterator<EPGMEdge> edgeIterator = transaction.getEdges().iterator();
        while (edgeIterator.hasNext()) {
            EPGMEdge next2 = edgeIterator.next();
            if (this.frequentEdgeLabels.contains(next2.getLabel())) {
                referenceEdgeIds.add(next2.getSourceId());
                referenceEdgeIds.add(next2.getTargetId());
                continue;
            }
            edgeIterator.remove();
        }
        transaction.getVertices().removeIf(next -> !referenceEdgeIds.contains(next.getId()));
        return transaction;
    }
}

