/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.common.functions;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class FilterVerticesByLabel
extends RichMapFunction<GraphTransaction, GraphTransaction> {
    private Collection<String> frequentVertexLabels;

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        List broadcast = this.getRuntimeContext().getBroadcastVariable("fvl");
        this.frequentVertexLabels = Sets.newHashSet((Iterable)broadcast);
    }

    public GraphTransaction map(GraphTransaction transaction) throws Exception {
        HashSet keptVertexIds = Sets.newHashSet();
        Iterator<EPGMVertex> vertexIterator = transaction.getVertices().iterator();
        while (vertexIterator.hasNext()) {
            EPGMVertex next2 = vertexIterator.next();
            if (this.frequentVertexLabels.contains(next2.getLabel())) {
                keptVertexIds.add(next2.getId());
                continue;
            }
            vertexIterator.remove();
        }
        transaction.getEdges().removeIf(next -> !keptVertexIds.contains(next.getSourceId()) || !keptVertexIds.contains(next.getTargetId()));
        return transaction;
    }
}

