/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.common.functions;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.util.Collector;
import org.gradoop.flink.model.impl.tuples.WithCount;

public class SortedDictionary
implements GroupReduceFunction<WithCount<String>, Map<String, Integer>> {
    public void reduce(Iterable<WithCount<String>> iterable, Collector<Map<String, Integer>> collector) throws Exception {
        HashMap dictionary = Maps.newHashMap();
        TreeMap sortedLabels = Maps.newTreeMap();
        for (WithCount<String> labelFrequency : iterable) {
            String label = labelFrequency.getObject();
            Long frequency = labelFrequency.getCount();
            Collection siblings = sortedLabels.computeIfAbsent(frequency, k -> new TreeSet());
            siblings.add(label);
        }
        int translation = 0;
        for (Collection siblings : sortedLabels.values()) {
            for (String label : siblings) {
                dictionary.put(label, translation);
                ++translation;
            }
        }
        collector.collect((Object)dictionary);
    }
}

