/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.common.functions;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Set;
import org.apache.flink.api.common.functions.MapFunction;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.model.impl.tuples.IdWithLabel;
import org.gradoop.flink.representation.common.adjacencylist.AdjacencyListCell;
import org.gradoop.flink.representation.common.adjacencylist.AdjacencyListRow;
import org.gradoop.flink.representation.transactional.AdjacencyList;

public class ToUndirectedAdjacencyList
implements MapFunction<GraphTransaction, AdjacencyList<GradoopId, String, IdWithLabel, IdWithLabel>> {
    public AdjacencyList<GradoopId, String, IdWithLabel, IdWithLabel> map(GraphTransaction transaction) throws Exception {
        Set<EPGMVertex> vertices = transaction.getVertices();
        Set<EPGMEdge> edges = transaction.getEdges();
        int vertexCount = vertices.size();
        HashMap rows = Maps.newHashMapWithExpectedSize((int)vertexCount);
        HashMap labels = Maps.newHashMapWithExpectedSize((int)vertexCount);
        for (EPGMVertex vertex : vertices) {
            labels.put(vertex.getId(), vertex.getLabel());
        }
        for (EPGMEdge edge : edges) {
            GradoopId sourceId = edge.getSourceId();
            GradoopId targetId = edge.getTargetId();
            AdjacencyListRow sourceRow = rows.computeIfAbsent(sourceId, k -> new AdjacencyListRow());
            IdWithLabel edgeData = new IdWithLabel(edge.getId(), edge.getLabel());
            IdWithLabel targetData = new IdWithLabel(targetId, (String)labels.get(targetId));
            sourceRow.getCells().add(new AdjacencyListCell<IdWithLabel, IdWithLabel>(edgeData, targetData));
            if (sourceId.equals((Object)targetId)) continue;
            IdWithLabel sourceData = new IdWithLabel(sourceId, (String)labels.get(sourceId));
            AdjacencyListRow targetRow = rows.computeIfAbsent(targetId, k -> new AdjacencyListRow());
            targetRow.getCells().add(new AdjacencyListCell<IdWithLabel, IdWithLabel>(edgeData, sourceData));
        }
        return new AdjacencyList<GradoopId, String, IdWithLabel, IdWithLabel>(transaction.getGraphHead(), labels, null, rows, Maps.newHashMap());
    }
}

