/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.tle;

import org.apache.flink.api.java.DataSet;
import org.gradoop.flink.algorithms.fsm.transactional.common.FSMConfig;
import org.gradoop.flink.algorithms.fsm.transactional.tle.TransactionalFSMBase;
import org.gradoop.flink.algorithms.fsm.transactional.tle.functions.JoinEmbeddings;
import org.gradoop.flink.algorithms.fsm.transactional.tle.functions.MergeEmbeddings;
import org.gradoop.flink.algorithms.fsm.transactional.tle.pojos.FSMGraph;
import org.gradoop.flink.algorithms.fsm.transactional.tle.tuples.Subgraph;
import org.gradoop.flink.algorithms.fsm.transactional.tle.tuples.SubgraphEmbeddings;
import org.gradoop.flink.model.impl.functions.utils.LeftSide;

public abstract class ThinkLikeAnEmbeddingFSMBase<G extends FSMGraph, S extends Subgraph, SE extends SubgraphEmbeddings>
extends TransactionalFSMBase {
    public ThinkLikeAnEmbeddingFSMBase(FSMConfig fsmConfig) {
        super(fsmConfig);
    }

    protected DataSet<SE> growEmbeddingsOfFrequentSubgraphs(DataSet<SE> parents, DataSet<S> frequentSubgraphs) {
        parents = this.filterByFrequentSubgraphs((DataSet<SE>)parents, frequentSubgraphs);
        parents = parents.groupBy(new int[]{0}).reduceGroup(new MergeEmbeddings());
        return parents.flatMap(new JoinEmbeddings(this.fsmConfig));
    }

    protected DataSet<SE> filterByFrequentSubgraphs(DataSet<SE> embeddings, DataSet<S> frequentSubgraphs) {
        return embeddings.joinWithTiny(frequentSubgraphs).where(new int[]{2}).equalTo(new int[]{0}).with(new LeftSide());
    }
}

