/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.algorithms.fsm.transactional.tle;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.flink.algorithms.fsm.dimspan.functions.mining.Frequent;
import org.gradoop.flink.algorithms.fsm.transactional.common.FSMConfig;
import org.gradoop.flink.algorithms.fsm.transactional.common.functions.DropPropertiesAndGraphContainment;
import org.gradoop.flink.algorithms.fsm.transactional.common.functions.EdgeLabels;
import org.gradoop.flink.algorithms.fsm.transactional.common.functions.FilterEdgesByLabel;
import org.gradoop.flink.algorithms.fsm.transactional.common.functions.FilterVerticesByLabel;
import org.gradoop.flink.algorithms.fsm.transactional.common.functions.NotEmpty;
import org.gradoop.flink.algorithms.fsm.transactional.common.functions.VertexLabels;
import org.gradoop.flink.algorithms.fsm.transactional.tle.functions.MinFrequency;
import org.gradoop.flink.model.api.operators.UnaryCollectionToCollectionOperator;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.functions.tuple.ValueOfWithCount;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.model.impl.operators.count.Count;
import org.gradoop.flink.util.GradoopFlinkConfig;

public abstract class TransactionalFSMBase
implements UnaryCollectionToCollectionOperator {
    protected final FSMConfig fsmConfig;
    protected DataSet<Long> graphCount;
    protected DataSet<Long> minFrequency;
    protected GradoopFlinkConfig config;

    public TransactionalFSMBase(FSMConfig fsmConfig) {
        this.fsmConfig = fsmConfig;
    }

    @Override
    public GraphCollection execute(GraphCollection collection) {
        this.config = collection.getConfig();
        DataSet<GraphTransaction> input = collection.getGraphTransactions();
        DataSet<GraphTransaction> output = this.execute(input);
        return collection.getFactory().fromTransactions(output);
    }

    @Override
    protected abstract DataSet<GraphTransaction> execute(DataSet<GraphTransaction> var1);

    protected DataSet<GraphTransaction> preProcess(DataSet<GraphTransaction> transactions) {
        transactions = transactions.map((MapFunction)new DropPropertiesAndGraphContainment());
        this.graphCount = Count.count(transactions);
        this.minFrequency = this.graphCount.map((MapFunction)new MinFrequency(this.fsmConfig));
        MapOperator frequentVertexLabels = ((FilterOperator)transactions.flatMap((FlatMapFunction)new VertexLabels()).groupBy(new int[]{0}).sum(1).filter(new Frequent()).withBroadcastSet(this.minFrequency, "fmin")).map(new ValueOfWithCount());
        transactions = transactions.map((MapFunction)new FilterVerticesByLabel()).withBroadcastSet((DataSet)frequentVertexLabels, "fvl");
        MapOperator frequentEdgeLabels = ((FilterOperator)transactions.flatMap((FlatMapFunction)new EdgeLabels()).groupBy(new int[]{0}).sum(1).filter(new Frequent()).withBroadcastSet(this.minFrequency, "fmin")).map(new ValueOfWithCount());
        transactions = transactions.map((MapFunction)new FilterEdgesByLabel()).withBroadcastSet((DataSet)frequentEdgeLabels, "fel");
        transactions = transactions.filter((FilterFunction)new NotEmpty());
        return transactions;
    }
}

